/*
 * Decompiled with CFR 0.152.
 */
package com.log.mall.controller;

import cn.hutool.json.JSONUtil;
import com.dingtalk.api.DefaultDingTalkClient;
import com.dingtalk.api.request.OapiSnsGetuserinfoBycodeRequest;
import com.log.mall.common.constants.Constants;
import com.log.mall.common.result.ResultCode;
import com.log.mall.common.result.ServiceResult;
import com.log.mall.config.DingConfig;
import com.log.mall.domain.AppUserBean;
import com.log.mall.domain.vo.DingAuthResponse;
import com.log.mall.service.IAppUserService;
import com.taobao.api.ApiException;
import com.taobao.api.TaobaoRequest;
import com.taobao.api.TaobaoResponse;
import java.util.Date;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/ding"})
public class DingAuthControl {
    private static final Logger log = LogManager.getLogger(DingAuthControl.class);
    @Autowired
    private IAppUserService userInfoService;

    @GetMapping(name="\u9489\u9489\u6388\u6743", value={"/applet/auth"})
    @CrossOrigin(origins={"*"}, methods={RequestMethod.GET, RequestMethod.POST})
    public ServiceResult<?> authCode(@RequestParam(value="authCode") String authCode, @RequestParam(value="appType", required=false) Long appType) {
        try {
            DefaultDingTalkClient client = new DefaultDingTalkClient(DingConfig.URL_GET_USER_INFO);
            OapiSnsGetuserinfoBycodeRequest req = new OapiSnsGetuserinfoBycodeRequest();
            req.setTmpAuthCode(authCode);
            TaobaoResponse response = client.execute((TaobaoRequest)req, DingConfig.getAppId((Long)appType), DingConfig.getAppSecret((Long)appType));
            if (Constants.DING_AUTH_SUCCESS.equals(response.getErrorCode())) {
                DingAuthResponse authResponse = (DingAuthResponse)JSONUtil.toBean((String)response.getBody(), DingAuthResponse.class);
                this.saveUserInfo(authResponse, appType);
                return ServiceResult.getSuccessResult((Object)authResponse.getUser_info());
            }
            if (Constants.DING_AUTH_ERROR_CODE.equals(response.getErrorCode())) {
                return ServiceResult.getFailureResult((ResultCode)ResultCode.DING_NONE_CODE_ERROR);
            }
            log.error("\u9489\u9489\u9274\u6743\u5f02\u5e38\uff1a {}", (Object)response.toString());
            return ServiceResult.getFailureResult((ResultCode)ResultCode.DING_AUTH_ERROR);
        }
        catch (ApiException e) {
            e.printStackTrace();
            return ServiceResult.getFailureResult((ResultCode)ResultCode.ERROR);
        }
    }

    private void saveUserInfo(DingAuthResponse authResponse, Long appType) {
        AppUserBean userBean = new AppUserBean();
        userBean.setOpenId(authResponse.getUser_info().getOpenid());
        userBean.setUnionId(authResponse.getUser_info().getUnionid());
        userBean.setNick(authResponse.getUser_info().getNick());
        userBean.setAvatar(authResponse.getUser_info().getAvatar());
        userBean.setAppId(appType);
        userBean.setCreateTime(new Date());
        this.userInfoService.insertAppUser(userBean);
    }
}

