/*
 * Decompiled with CFR 0.152.
 */
package com.log.mall.config;

import com.log.mall.common.constants.TopicName;
import com.log.mall.receiver.MessageReceiver;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.MessageListener;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.listener.PatternTopic;
import org.springframework.data.redis.listener.RedisMessageListenerContainer;
import org.springframework.data.redis.listener.Topic;
import org.springframework.data.redis.listener.adapter.MessageListenerAdapter;

@Configuration
@AutoConfigureAfter(value={MessageReceiver.class})
public class SubscriberConfig {
    @Bean
    public RedisMessageListenerContainer getRedisMessageListenerContainer(RedisConnectionFactory redisConnectionFactory, MessageListenerAdapter messageListenerAdapter, MessageListenerAdapter recordListenerAdapter) {
        RedisMessageListenerContainer redisMessageListenerContainer = new RedisMessageListenerContainer();
        redisMessageListenerContainer.setConnectionFactory(redisConnectionFactory);
        redisMessageListenerContainer.addMessageListener((MessageListener)messageListenerAdapter, (Topic)new PatternTopic(TopicName.TOPIC_LOG));
        redisMessageListenerContainer.addMessageListener((MessageListener)recordListenerAdapter, (Topic)new PatternTopic(TopicName.TOPIC_RECORD));
        return redisMessageListenerContainer;
    }

    @Bean
    public MessageListenerAdapter messageListenerAdapter(MessageReceiver receiver) {
        return new MessageListenerAdapter((Object)receiver, "logReceive");
    }

    @Bean
    public MessageListenerAdapter recordListenerAdapter(MessageReceiver receiver) {
        return new MessageListenerAdapter((Object)receiver, "recordReceive");
    }
}

