/*
 * Decompiled with CFR 0.152.
 */
package com.log.mall.common.result;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.log.mall.common.result.ResultCode;
import java.io.Serializable;

public class ServiceResult<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String errCode;
    private String errMsg;
    private T data;

    private ServiceResult() {
    }

    public String getErrCode() {
        return this.errCode;
    }

    public void setErrCode(String errCode) {
        this.errCode = errCode;
    }

    public String getErrMsg() {
        return this.errMsg;
    }

    public void setErrMsg(String errMsg) {
        this.errMsg = errMsg;
    }

    public T getData() {
        return (T)this.data;
    }

    public void setData(T data) {
        this.data = data;
    }

    public boolean isSucceed() {
        return ResultCode.SUCCESS.getCode().equals(this.errCode);
    }

    public static <T> ServiceResult<T> getSuccessResult(T payload) {
        ServiceResult result = new ServiceResult();
        result.setErrCode(ResultCode.SUCCESS.getCode());
        result.setErrMsg(null);
        result.setData(payload);
        return result;
    }

    public static <T> ServiceResult<T> getSuccessResult() {
        ServiceResult result = new ServiceResult();
        result.setErrCode(ResultCode.SUCCESS.getCode());
        result.setErrMsg(null);
        result.setData(null);
        return result;
    }

    public static <T> ServiceResult<T> getFailureResult(String errCode, String errMsg) {
        ServiceResult result = new ServiceResult();
        result.setErrCode(errCode);
        result.setErrMsg(errMsg);
        return result;
    }

    public static <T> ServiceResult<T> getFailureResult(ResultCode resultCode) {
        ServiceResult result = new ServiceResult();
        result.setErrCode(resultCode.getCode());
        result.setErrMsg(resultCode.getContent());
        return result;
    }

    public static <T> ServiceResult<T> getFailureResult() {
        ServiceResult result = new ServiceResult();
        result.setErrCode(ResultCode.ERROR.getCode());
        result.setErrMsg(ResultCode.ERROR.getContent());
        return result;
    }

    public String toString() {
        return JSON.toJSONString((Object)this, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
    }
}

