/*
 * Decompiled with CFR 0.152.
 */
package com.forwe.bp.utils;

import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.HashOperations;
import org.springframework.data.redis.core.ListOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.SetOperations;
import org.springframework.data.redis.core.ValueOperations;
import org.springframework.data.redis.core.ZSetOperations;
import org.springframework.stereotype.Service;

@Service
public class RedisUtils {
    @Autowired
    private RedisTemplate redisTemplate;
    private static double size = Math.pow(2.0, 32.0);

    public boolean setBit(String key, long offset, boolean isShow) {
        boolean result = false;
        try {
            ValueOperations operations = this.redisTemplate.opsForValue();
            operations.setBit((Object)key, offset, isShow);
            result = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public boolean getBit(String key, long offset) {
        boolean result = false;
        try {
            ValueOperations operations = this.redisTemplate.opsForValue();
            result = operations.getBit((Object)key, offset);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public boolean set(String key, Object value) {
        boolean result = false;
        try {
            ValueOperations operations = this.redisTemplate.opsForValue();
            operations.set((Object)key, value);
            result = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public boolean set(String key, Object value, Long expireTime) {
        boolean result = false;
        try {
            ValueOperations operations = this.redisTemplate.opsForValue();
            operations.set((Object)key, value);
            this.redisTemplate.expire((Object)key, expireTime.longValue(), TimeUnit.SECONDS);
            result = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public void remove(String ... keys) {
        for (String key : keys) {
            this.remove(key);
        }
    }

    public void remove(String key) {
        if (this.exists(key)) {
            this.redisTemplate.delete((Object)key);
        }
    }

    public boolean exists(String key) {
        return this.redisTemplate.hasKey((Object)key);
    }

    public Object get(String key) {
        Object result = null;
        ValueOperations operations = this.redisTemplate.opsForValue();
        result = operations.get((Object)key);
        return result;
    }

    public void hmSet(String key, Object hashKey, Object value) {
        HashOperations hash = this.redisTemplate.opsForHash();
        hash.put((Object)key, hashKey, value);
    }

    public Object hmGet(String key, Object hashKey) {
        HashOperations hash = this.redisTemplate.opsForHash();
        return hash.get((Object)key, hashKey);
    }

    public void lPush(String k, Object v) {
        ListOperations list = this.redisTemplate.opsForList();
        list.rightPush((Object)k, v);
    }

    public List<Object> lRange(String k, long l, long l1) {
        ListOperations list = this.redisTemplate.opsForList();
        return list.range((Object)k, l, l1);
    }

    public void add(String key, Object value) {
        SetOperations set = this.redisTemplate.opsForSet();
        set.add((Object)key, new Object[]{value});
    }

    public Set<Object> setMembers(String key) {
        SetOperations set = this.redisTemplate.opsForSet();
        return set.members((Object)key);
    }

    public void zAdd(String key, Object value, double scoure) {
        ZSetOperations zset = this.redisTemplate.opsForZSet();
        zset.add((Object)key, value, scoure);
    }

    public Set<Object> rangeByScore(String key, double scoure, double scoure1) {
        ZSetOperations zset = this.redisTemplate.opsForZSet();
        this.redisTemplate.opsForValue();
        return zset.rangeByScore((Object)key, scoure, scoure1);
    }

    public void saveDataToRedis(String name) {
        double index = Math.abs((double)name.hashCode() % size);
        long indexLong = new Double(index).longValue();
        boolean availableUsers = this.setBit("availableUsers", indexLong, true);
    }

    public boolean getDataToRedis(String name) {
        double index = Math.abs((double)name.hashCode() % size);
        long indexLong = new Double(index).longValue();
        return this.getBit("availableUsers", indexLong);
    }

    public Long zRank(String key, Object value) {
        ZSetOperations zset = this.redisTemplate.opsForZSet();
        return zset.rank((Object)key, value);
    }

    public Set<ZSetOperations.TypedTuple<Object>> zRankWithScore(String key, long start, long end) {
        ZSetOperations zset = this.redisTemplate.opsForZSet();
        Set ret = zset.rangeWithScores((Object)key, start, end);
        return ret;
    }

    public Double zSetScore(String key, Object value) {
        ZSetOperations zset = this.redisTemplate.opsForZSet();
        return zset.score((Object)key, value);
    }

    public void incrementScore(String key, Object value, double scoure) {
        ZSetOperations zset = this.redisTemplate.opsForZSet();
        zset.incrementScore((Object)key, value, scoure);
    }

    public Set<ZSetOperations.TypedTuple<Object>> reverseZRankWithScore(String key, long start, long end) {
        ZSetOperations zset = this.redisTemplate.opsForZSet();
        Set ret = zset.reverseRangeByScoreWithScores((Object)key, (double)start, (double)end);
        return ret;
    }

    public Set<ZSetOperations.TypedTuple<Object>> reverseZRankWithRank(String key, long start, long end) {
        ZSetOperations zset = this.redisTemplate.opsForZSet();
        Set ret = zset.reverseRangeWithScores((Object)key, start, end);
        return ret;
    }
}

