/*
 * Decompiled with CFR 0.152.
 */
package com.forwe.bp.service.impl;

import com.alibaba.fastjson.JSON;
import com.forwe.bp.config.EventManagerExecutor;
import com.forwe.bp.domain.OrderReportBean;
import com.forwe.bp.domain.ReportBean;
import com.forwe.bp.domain.ro.ReportListRo;
import com.forwe.bp.domain.vo.ActivityDataExcelResponse;
import com.forwe.bp.domain.vo.QygShopDataResponse;
import com.forwe.bp.domain.vo.RecordStatisticsResponse;
import com.forwe.bp.domain.vo.RecordStatisticsVO;
import com.forwe.bp.domain.vo.ReportPageResponse;
import com.forwe.bp.domain.vo.ShopDataExcelResponse;
import com.forwe.bp.mapper.forwe.OrderReportMapper;
import com.forwe.bp.mapper.primary.ReportMapper;
import com.forwe.bp.service.IReportService;
import com.forwe.bp.utils.DateUtils;
import com.forwe.bp.utils.StringUtils;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.compress.utils.Lists;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="reportBeanService")
public class ReportServiceImpl
implements IReportService {
    @Resource
    private ReportMapper reportMapper;
    @Resource
    private OrderReportMapper orderReportMapper;
    @Resource
    private StringRedisTemplate stringRedisTemplate;
    public static final String SHOP_DATE_REDIS_KEY = "SHOP_DATE_%s ~ %s";

    public ReportBean queryById(Long id) {
        return this.reportMapper.queryById(id);
    }

    public Page<ReportBean> queryByPage(ReportBean reportBean, PageRequest pageRequest) {
        long total = this.reportMapper.count(reportBean);
        return new PageImpl(this.reportMapper.queryAllByLimit(reportBean, (Pageable)pageRequest), (Pageable)pageRequest, total);
    }

    public ReportBean insert(ReportBean reportBean) {
        this.reportMapper.insert(reportBean);
        return reportBean;
    }

    public ReportBean update(ReportBean reportBean) {
        this.reportMapper.update(reportBean);
        return this.queryById(reportBean.getId());
    }

    public boolean deleteById(Long id) {
        return this.reportMapper.deleteById(id) > 0;
    }

    public List<ReportPageResponse> selectReportPageList(ReportListRo request) {
        return this.reportMapper.selectReportPageList(request);
    }

    public List<ActivityDataExcelResponse> selectActivityData(ReportListRo request) {
        return this.reportMapper.selectActivityData(request);
    }

    public List<ShopDataExcelResponse> selectShopData(ReportListRo request) {
        String json;
        if (StringUtils.isEmpty((String)request.getStartDate()) || StringUtils.isEmpty((String)request.getEndDate())) {
            request.setStartDate(DateUtils.getDate());
            request.setEndDate(request.getStartDate());
        }
        String key = String.format(SHOP_DATE_REDIS_KEY, request.getStartDate(), request.getEndDate());
        if (request.getIfImport().booleanValue() && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)(json = (String)this.stringRedisTemplate.opsForValue().get((Object)key)))) {
            return JSON.parseArray((String)json, ShopDataExcelResponse.class);
        }
        List shopData = this.reportMapper.selectShopData(request);
        Consumer<ShopDataExcelResponse> dealWithProductOrderInfo = item -> {
            if (!StringUtils.isEmpty((String)item.getProductCode()) && item.getProductType() != null) {
                OrderReportBean orderReportBean = item.getProductType() == 1 ? this.orderReportMapper.queryOmsOrderReport(item.getProductCode(), item.getCreateDate(), item.getSourceCode()) : this.orderReportMapper.queryVirtualOrderReport(item.getProductCode(), item.getCreateDate(), item.getSourceCode());
                item.setOrderCount(orderReportBean.getSellCount());
                item.setOrderUv(orderReportBean.getOrderUv());
                item.setFinishOrderCount(orderReportBean.getFinishCount());
            }
        };
        List futures = shopData.parallelStream().map(shopDataExcelResponse -> CompletableFuture.runAsync(() -> dealWithProductOrderInfo.accept((ShopDataExcelResponse)shopDataExcelResponse), (Executor)EventManagerExecutor.executor)).collect(Collectors.toList());
        long count = futures.stream().map(CompletableFuture::join).count();
        if (request.getIfImport().booleanValue()) {
            this.stringRedisTemplate.opsForValue().set((Object)key, (Object)JSON.toJSONString((Object)shopData), 86400L, TimeUnit.SECONDS);
        }
        return shopData;
    }

    public List<QygShopDataResponse> selectQygShopData(ReportListRo request) {
        if (StringUtils.isEmpty((String)request.getStartDate()) || StringUtils.isEmpty((String)request.getEndDate())) {
            request.setStartDate(DateUtils.getDate());
            request.setEndDate(request.getStartDate());
        }
        List shopData = this.reportMapper.selectQygData(request);
        return shopData;
    }

    public List<RecordStatisticsResponse> getTotalAndDetailUVData(ReportListRo request) {
        List statistics;
        if (StringUtils.isEmpty((String)request.getStartDate()) || StringUtils.isEmpty((String)request.getEndDate())) {
            request.setStartDate(DateUtils.getDate());
            request.setEndDate(DateUtils.getDate());
        }
        if (CollectionUtils.isEmpty((Collection)(statistics = this.reportMapper.getStatistics(request)))) {
            return Lists.newArrayList();
        }
        List<RecordStatisticsResponse> data = statistics.stream().map(arg_0 -> this.packageResVO(arg_0)).collect(Collectors.toList());
        request.setCode("qyg_detail");
        request.setTag("detail");
        List productDetailStatistics = this.reportMapper.getStatistics(request);
        if (CollectionUtils.isEmpty((Collection)productDetailStatistics)) {
            return data;
        }
        Map<String, Integer> productDetailMap = productDetailStatistics.stream().collect(Collectors.groupingBy(RecordStatisticsVO::getCreateDate, Collectors.summingInt(RecordStatisticsVO::getUv)));
        data.forEach(s -> {
            if (Objects.nonNull(productDetailMap.get(s.getCreateDate()))) {
                s.setProductDetailUv(Integer.valueOf(Objects.isNull(productDetailMap.get(s.getCreateDate())) ? 0 : (Integer)productDetailMap.get(s.getCreateDate())));
            }
        });
        return data;
    }

    private RecordStatisticsResponse packageResVO(RecordStatisticsVO vo) {
        RecordStatisticsResponse res = new RecordStatisticsResponse();
        res.setCreateDate(vo.getCreateDate());
        res.setTotalUv(vo.getUv());
        res.setProductDetailUv(Integer.valueOf(0));
        return res;
    }

    public List<ReportBean> queryAll(ReportBean reportBean) {
        if (reportBean == null) {
            return Lists.newArrayList();
        }
        return this.reportMapper.queryAll(reportBean);
    }
}

