/*
 * Decompiled with CFR 0.152.
 */
package com.forwe.bp.service.impl;

import cn.hutool.core.date.DateUtil;
import com.forwe.bp.domain.RecordBean;
import com.forwe.bp.domain.ReportBean;
import com.forwe.bp.domain.ro.RecordBeanRo;
import com.forwe.bp.mapper.primary.RecordMapper;
import com.forwe.bp.mapper.primary.ReportMapper;
import com.forwe.bp.mapper.primary.TodayRecordMapper;
import com.forwe.bp.service.IRecordService;
import com.forwe.bp.utils.StringUtils;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class RecordServiceImpl
implements IRecordService {
    @Resource
    private RecordMapper recordMapper;
    @Resource
    private ReportMapper reportMapper;
    @Resource
    private TodayRecordMapper todayRecordMapper;

    public void saveRecord(RecordBeanRo recordBeanRo) {
        RecordBean recordBean = new RecordBean();
        BeanUtils.copyProperties((Object)recordBeanRo, (Object)recordBean);
        recordBean.setCreateTime(new Date());
        recordBean.setCreateDate(DateUtil.formatDate((Date)recordBean.getCreateTime()));
        if (StringUtils.isEmpty((String)recordBean.getCode())) {
            recordBean.setCode(recordBeanRo.getEventKey().substring(0, recordBeanRo.getEventKey().indexOf("_")));
            if (recordBeanRo.getEventKey().contains("Page_View")) {
                recordBean.setType(Integer.valueOf(1));
                recordBeanRo.getAttributes().forEach(item -> {
                    if ("pageTag".equals(item.getAttrKey())) {
                        recordBean.setTag(item.getAttrValue());
                    }
                    if ("pageName".equals(item.getAttrKey())) {
                        recordBean.setName(item.getAttrValue());
                        recordBean.setPageName(item.getAttrValue());
                    }
                });
            } else {
                recordBean.setType(Integer.valueOf(2));
                recordBeanRo.getAttributes().forEach(item -> {
                    if ("viewTag".equals(item.getAttrKey())) {
                        recordBean.setTag(item.getAttrValue());
                    }
                    if ("viewName".equals(item.getAttrKey())) {
                        recordBean.setName(item.getAttrValue());
                    }
                    if ("pageName".equals(item.getAttrKey())) {
                        recordBean.setPageName(item.getAttrValue());
                    }
                });
            }
        }
        this.recordMapper.insert(recordBean);
        Integer uvExist = this.todayRecordMapper.exist(recordBean);
        this.todayRecordMapper.insert(recordBean);
        ReportBean reportBean = new ReportBean();
        reportBean.setCode(recordBean.getCode());
        reportBean.setAppId(Integer.valueOf(recordBean.getAppId().intValue()));
        reportBean.setType(recordBean.getType());
        reportBean.setTag(recordBean.getTag());
        reportBean.setName(recordBean.getName());
        reportBean.setCreateDate(recordBean.getCreateDate());
        reportBean.setProductCode(recordBean.getProductCode());
        reportBean.setProductType(recordBean.getProductType());
        reportBean.setSource(recordBean.getSource());
        reportBean.setPageName(recordBean.getPageName());
        List reportBeanList = this.reportMapper.queryAll(reportBean);
        if (reportBeanList == null || reportBeanList.size() == 0) {
            reportBean.setUv(Integer.valueOf(1));
            reportBean.setPv(Integer.valueOf(1));
            this.reportMapper.insert(reportBean);
        } else {
            this.reportMapper.updateUvPv(((ReportBean)reportBeanList.get(0)).getId(), Boolean.valueOf(uvExist != null && uvExist == 1));
        }
    }
}

