/*
 * Decompiled with CFR 0.152.
 */
package com.forwe.bp.datasource;

import javax.sql.DataSource;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.SqlSessionFactoryBean;
import org.mybatis.spring.SqlSessionTemplate;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.jdbc.DataSourceBuilder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;

@Configuration
@MapperScan(basePackages={"com.forwe.bp.mapper.forwe"}, sqlSessionFactoryRef="forweSqlSessionFactory")
public class ForweDataSourceConfig {
    @Bean(name={"forwe"})
    @ConfigurationProperties(prefix="spring.datasource.forwe")
    public DataSource dataSource() {
        return DataSourceBuilder.create().build();
    }

    @Bean(name={"forweSqlSessionFactory"})
    public SqlSessionFactory sqlSessionFactory(@Qualifier(value="forwe") DataSource dataSource) throws Exception {
        SqlSessionFactoryBean bean = new SqlSessionFactoryBean();
        bean.setDataSource(dataSource);
        bean.setMapperLocations(new PathMatchingResourcePatternResolver().getResources("classpath:mapper/forwe/*.xml"));
        return bean.getObject();
    }

    @Bean(name={"forweTransactionManager"})
    public DataSourceTransactionManager transactionManager(@Qualifier(value="forwe") DataSource dataSource) {
        return new DataSourceTransactionManager(dataSource);
    }

    @Bean(name={"forweSqlSessionTemplate"})
    public SqlSessionTemplate sqlSessionTemplate(@Qualifier(value="forweSqlSessionFactory") SqlSessionFactory sqlSessionFactory) {
        return new SqlSessionTemplate(sqlSessionFactory);
    }
}

