/*
 * Decompiled with CFR 0.152.
 */
package com.forwe.bp.controller;

import cn.hutool.poi.excel.ExcelUtil;
import cn.hutool.poi.excel.ExcelWriter;
import com.alibaba.fastjson.JSON;
import com.forwe.bp.common.result.PageResult;
import com.forwe.bp.common.result.ServiceResult;
import com.forwe.bp.config.TopicConfig;
import com.forwe.bp.controller.BaseController;
import com.forwe.bp.domain.ReportBean;
import com.forwe.bp.domain.ro.RecordBeanRo;
import com.forwe.bp.domain.ro.ReportListRo;
import com.forwe.bp.domain.vo.ActivityDataExcelResponse;
import com.forwe.bp.domain.vo.QygShopDataResponse;
import com.forwe.bp.domain.vo.RecordStatisticsResponse;
import com.forwe.bp.domain.vo.ReportPageResponse;
import com.forwe.bp.domain.vo.ShopDataExcelResponse;
import com.forwe.bp.service.IPublishService;
import com.forwe.bp.service.IReportService;
import java.io.OutputStream;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/record"})
public class RecordController
extends BaseController {
    private static final Logger log = Logger.getLogger(RecordController.class);
    @Autowired
    IPublishService publishService;
    @Autowired
    IReportService reportService;
    @Autowired
    private TopicConfig topicConfig;

    @PostMapping(value={"/upload"})
    @CrossOrigin(origins={"*"}, methods={RequestMethod.POST})
    public ServiceResult<?> sendMessage(@RequestBody RecordBeanRo recordBeanRo) {
        this.publishService.sendMessage(this.topicConfig.getTopicName(), (Object)JSON.toJSONString((Object)recordBeanRo));
        return ServiceResult.getSuccessResult((Object)true);
    }

    @GetMapping(value={"/page"})
    @CrossOrigin(origins={"*"}, methods={RequestMethod.GET})
    public PageResult<ReportPageResponse> page(ReportListRo request) {
        this.startPage();
        List list = this.reportService.selectReportPageList(request);
        return this.getPageResult(list);
    }

    @GetMapping(value={"/list"})
    @CrossOrigin(origins={"*"}, methods={RequestMethod.GET})
    public ServiceResult<?> list(ReportListRo request) {
        return ServiceResult.getSuccessResult((Object)this.reportService.selectReportPageList(request));
    }

    @GetMapping(value={"/activity/page"})
    @CrossOrigin(origins={"*"}, methods={RequestMethod.GET})
    public PageResult<ActivityDataExcelResponse> activityPage(ReportListRo request) {
        this.startPage();
        List list = this.reportService.selectActivityData(request);
        return this.getPageResult(list);
    }

    @GetMapping(value={"/activity/list"})
    @CrossOrigin(origins={"*"}, methods={RequestMethod.GET})
    public ServiceResult<?> activityList(ReportListRo request) {
        return ServiceResult.getSuccessResult((Object)this.reportService.selectActivityData(request));
    }

    @GetMapping(value={"/download/activity"})
    @CrossOrigin(origins={"*"}, methods={RequestMethod.GET})
    public void downloadActivityData(ReportListRo request, HttpServletResponse response) {
        try {
            List data = this.reportService.selectActivityData(request);
            ExcelWriter writer = ExcelUtil.getWriter((boolean)true);
            writer.addHeaderAlias("platform", "\u5e73\u53f0");
            writer.addHeaderAlias("masterTag", "\u4e3b\u6807\u8bb0");
            writer.addHeaderAlias("masterMemo", "\u4e3b\u6807\u8bb0\u63cf\u8ff0");
            writer.addHeaderAlias("slaveTag", "\u5206\u6807\u8bb0");
            writer.addHeaderAlias("slaveMemo", "\u5206\u6807\u8bb0\u63cf\u8ff0");
            writer.addHeaderAlias("uv", "\u4eba\u6570");
            writer.addHeaderAlias("pv", "\u70b9\u51fb\u6570");
            writer.addHeaderAlias("createDate", "\u65e5\u671f");
            if (data.size() != 0) {
                writer.write((Iterable)data, true);
            }
            writer.flush((OutputStream)response.getOutputStream());
            writer.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @GetMapping(value={"/forwe/page"})
    @CrossOrigin(origins={"*"}, methods={RequestMethod.GET})
    public PageResult<ShopDataExcelResponse> forwePage(ReportListRo request) {
        this.startPage();
        List list = this.reportService.selectShopData(request);
        return this.getPageResult(list);
    }

    @GetMapping(value={"/forwe/queryAll"})
    @CrossOrigin(origins={"*"}, methods={RequestMethod.GET})
    public List<ReportBean> queryAll(ReportBean request) {
        return this.reportService.queryAll(request);
    }

    @GetMapping(value={"/qyg/page"})
    @CrossOrigin(origins={"*"}, methods={RequestMethod.GET})
    public PageResult<QygShopDataResponse> qygPage(ReportListRo request) {
        this.startPage();
        List list = this.reportService.selectQygShopData(request);
        return this.getPageResult(list);
    }

    @GetMapping(value={"/qyg/getTotalAndDetailUVData"})
    @CrossOrigin(origins={"*"}, methods={RequestMethod.GET})
    public List<RecordStatisticsResponse> getTotalAndDetailUVData(ReportListRo request) {
        List list = this.reportService.getTotalAndDetailUVData(request);
        return list;
    }

    @GetMapping(value={"/forwe/list"})
    @CrossOrigin(origins={"*"}, methods={RequestMethod.GET})
    public ServiceResult<?> forweList(ReportListRo request) {
        request.setIfImport(Boolean.valueOf(true));
        return ServiceResult.getSuccessResult((Object)this.reportService.selectShopData(request));
    }

    @GetMapping(value={"/download/forwe"})
    @CrossOrigin(origins={"*"}, methods={RequestMethod.GET})
    public void downloadForweData(ReportListRo request, HttpServletResponse response) {
        try {
            List data = this.reportService.selectShopData(request);
            ExcelWriter writer = ExcelUtil.getWriter((boolean)true);
            writer.addHeaderAlias("source", "\u6765\u6e90");
            writer.addHeaderAlias("pageName", "\u9875\u9762");
            writer.addHeaderAlias("pageUv", "\u9875\u9762UV");
            writer.addHeaderAlias("pagePv", "\u9875\u9762PV");
            writer.addHeaderAlias("productName", "\u5546\u54c1");
            writer.addHeaderAlias("productTag", "\u5546\u54c1TAG");
            writer.addHeaderAlias("productUv", "\u5546\u54c1UV");
            writer.addHeaderAlias("productPv", "\u5546\u54c1PV");
            writer.addHeaderAlias("orderCount", "\u4e0b\u5355\u91cf");
            writer.addHeaderAlias("orderUv", "\u4e0b\u5355\u91cfUV");
            writer.addHeaderAlias("finishOrderCount", "\u5546\u54c1\u6210\u4ea4\u91cf");
            writer.addHeaderAlias("createDate", "\u65e5\u671f");
            writer.setOnlyAlias(true);
            if (data.size() != 0) {
                writer.write((Iterable)data, true);
            }
            writer.flush((OutputStream)response.getOutputStream());
            writer.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

