/*
 * Decompiled with CFR 0.152.
 */
package com.forwe.bp.config;

import com.forwe.bp.config.TopicConfig;
import com.forwe.bp.receiver.MessageReceiver;
import java.util.concurrent.Executor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.MessageListener;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.listener.PatternTopic;
import org.springframework.data.redis.listener.RedisMessageListenerContainer;
import org.springframework.data.redis.listener.Topic;
import org.springframework.data.redis.listener.adapter.MessageListenerAdapter;

@Configuration
@AutoConfigureAfter(value={MessageReceiver.class})
public class SubscriberConfig {
    private Executor redisTaskExecutor;
    @Autowired
    private TopicConfig topicConfig;

    @Bean
    public RedisMessageListenerContainer getRedisMessageListenerContainer(RedisConnectionFactory redisConnectionFactory, MessageListenerAdapter recordListenerAdapter) {
        RedisMessageListenerContainer redisMessageListenerContainer = new RedisMessageListenerContainer();
        redisMessageListenerContainer.setConnectionFactory(redisConnectionFactory);
        if (this.redisTaskExecutor != null) {
            redisMessageListenerContainer.setTaskExecutor(this.redisTaskExecutor);
        }
        redisMessageListenerContainer.addMessageListener((MessageListener)recordListenerAdapter, (Topic)new PatternTopic(this.topicConfig.getTopicName()));
        return redisMessageListenerContainer;
    }

    @Bean
    public MessageListenerAdapter recordListenerAdapter(MessageReceiver receiver) {
        return new MessageListenerAdapter((Object)receiver, "recordReceive");
    }

    @Autowired(required=false)
    @Qualifier(value="springSessionRedisTaskExecutor")
    public void setRedisTaskExecutor(Executor redisTaskExecutor) {
        this.redisTaskExecutor = redisTaskExecutor;
    }
}

