/*
 * Decompiled with CFR 0.152.
 */
package com.forwe.bp.config;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.jedis.JedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.serializer.Jackson2JsonRedisSerializer;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;
import redis.clients.jedis.JedisPoolConfig;

@Configuration
public class RedisConfig {
    @Value(value="${spring.redis.jedis.pool.max-active}")
    private int redisPoolMaxActive;
    @Value(value="${spring.redis.jedis.pool.max-wait}")
    private int redisPoolMaxWait;
    @Value(value="${spring.redis.jedis.pool.max-idle}")
    private int redisPoolMaxIdle;
    @Value(value="${spring.redis.jedis.pool.min-idle}")
    private int redisPoolMinIdle;

    public JedisConnectionFactory createJedisConnectionFactory(int dbIndex, String host, int port, String password, int timeout) {
        JedisConnectionFactory jedisConnectionFactory = new JedisConnectionFactory();
        jedisConnectionFactory.setDatabase(dbIndex);
        jedisConnectionFactory.setHostName(host);
        jedisConnectionFactory.setPort(port);
        jedisConnectionFactory.setPassword(password);
        jedisConnectionFactory.setTimeout(timeout);
        jedisConnectionFactory.setPoolConfig(this.setPoolConfig(this.redisPoolMaxIdle, this.redisPoolMinIdle, this.redisPoolMaxActive, this.redisPoolMaxWait, true));
        return jedisConnectionFactory;
    }

    public JedisPoolConfig setPoolConfig(int maxIdle, int minIdle, int maxActive, int maxWait, boolean testOnBorrow) {
        JedisPoolConfig poolConfig = new JedisPoolConfig();
        poolConfig.setMaxIdle(maxIdle);
        poolConfig.setMinIdle(minIdle);
        poolConfig.setMaxTotal(maxActive);
        poolConfig.setMaxWaitMillis((long)maxWait);
        poolConfig.setTestOnBorrow(testOnBorrow);
        return poolConfig;
    }

    public void setSerializer(RedisTemplate template) {
        Jackson2JsonRedisSerializer jackson2JsonRedisSerializer = new Jackson2JsonRedisSerializer(Object.class);
        ObjectMapper om = new ObjectMapper();
        om.setVisibility(PropertyAccessor.ALL, JsonAutoDetect.Visibility.ANY);
        om.enableDefaultTyping(ObjectMapper.DefaultTyping.NON_FINAL);
        jackson2JsonRedisSerializer.setObjectMapper(om);
        StringRedisSerializer stringRedisSerializer = new StringRedisSerializer();
        template.setKeySerializer((RedisSerializer)stringRedisSerializer);
        template.setHashKeySerializer((RedisSerializer)stringRedisSerializer);
        template.setValueSerializer((RedisSerializer)jackson2JsonRedisSerializer);
        template.setHashValueSerializer((RedisSerializer)jackson2JsonRedisSerializer);
        template.afterPropertiesSet();
    }
}

