/*
 * Decompiled with CFR 0.152.
 */
package com.forwe.bp.config;

import com.forwe.bp.config.RedisConfig;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

@Configuration
@EnableCaching
public class LocalRedisConfig
extends RedisConfig {
    @Value(value="${spring.redis.database}")
    private int dbIndex;
    @Value(value="${spring.redis.host}")
    private String host;
    @Value(value="${spring.redis.port}")
    private int port;
    @Value(value="${spring.redis.password}")
    private String password;
    @Value(value="${spring.redis.timeout}")
    private int timeout;

    @Bean
    public RedisConnectionFactory defaultRedisConnectionFactory() {
        return this.createJedisConnectionFactory(this.dbIndex, this.host, this.port, this.password, this.timeout);
    }

    @Bean(name={"defaultRedisTemplate"})
    public StringRedisTemplate defaultRedisTemplate() {
        StringRedisTemplate template = new StringRedisTemplate();
        template.setConnectionFactory(this.defaultRedisConnectionFactory());
        this.setSerializer((RedisTemplate)template);
        template.afterPropertiesSet();
        return template;
    }

    @Bean
    public ThreadPoolTaskExecutor springSessionRedisTaskExecutor() {
        ThreadPoolTaskExecutor pool = new ThreadPoolTaskExecutor();
        int processNum = Runtime.getRuntime().availableProcessors();
        int corePoolSize = (int)((double)processNum / 0.5);
        int maxPoolSize = (int)((double)processNum / 0.19999999999999996);
        pool.setCorePoolSize(corePoolSize);
        pool.setMaxPoolSize(maxPoolSize);
        pool.setQueueCapacity(maxPoolSize * 1000);
        pool.setThreadPriority(10);
        pool.setDaemon(false);
        pool.setKeepAliveSeconds(60);
        pool.setThreadNamePrefix("Spring session redis executor thread: ");
        return pool;
    }
}

