/*
 * Decompiled with CFR 0.152.
 */
package com.forwe.bp.common.result;

import com.forwe.bp.common.result.ResultCode;
import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.util.List;

/*
 * Exception performing whole class analysis ignored.
 */
public class PageResult<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private long total;
    private int code;
    private String msg;
    private List<T> rows;

    public static <T> PageResult<T> ok() {
        return PageResult.restResult(null, (int)ResultCode.SUCCESS.getCode(), null);
    }

    public static <T> PageResult<T> ok(List<T> data) {
        return PageResult.restResult(data, (int)ResultCode.SUCCESS.getCode(), null);
    }

    public static <T> PageResult<T> ok(List<T> data, String msg) {
        return PageResult.restResult(data, (int)ResultCode.SUCCESS.getCode(), (String)msg);
    }

    public static <T> PageResult<T> failed() {
        return PageResult.restResult(null, (int)ResultCode.ERROR.getCode(), null);
    }

    public static <T> PageResult<T> failed(String msg) {
        return PageResult.restResult(null, (int)ResultCode.ERROR.getCode(), (String)msg);
    }

    public static <T> PageResult<T> failed(List<T> data) {
        return PageResult.restResult(data, (int)ResultCode.ERROR.getCode(), null);
    }

    public static <T> PageResult<T> failed(List<T> data, String msg) {
        return PageResult.restResult(data, (int)ResultCode.ERROR.getCode(), (String)msg);
    }

    private static <T> PageResult<T> restResult(List<T> data, int code, String msg) {
        PageResult apiResult = new PageResult();
        apiResult.setCode(code);
        apiResult.setRows(data);
        apiResult.setMsg(msg);
        return apiResult;
    }

    public String toString() {
        return "PageResult(total=" + this.getTotal() + ", code=" + this.getCode() + ", msg=" + this.getMsg() + ", rows=" + this.getRows() + ")";
    }

    public PageResult() {
    }

    @ConstructorProperties(value={"total", "code", "msg", "rows"})
    public PageResult(long total, int code, String msg, List<T> rows) {
        this.total = total;
        this.code = code;
        this.msg = msg;
        this.rows = rows;
    }

    public long getTotal() {
        return this.total;
    }

    public PageResult<T> setTotal(long total) {
        this.total = total;
        return this;
    }

    public int getCode() {
        return this.code;
    }

    public PageResult<T> setCode(int code) {
        this.code = code;
        return this;
    }

    public String getMsg() {
        return this.msg;
    }

    public PageResult<T> setMsg(String msg) {
        this.msg = msg;
        return this;
    }

    public List<T> getRows() {
        return this.rows;
    }

    public PageResult<T> setRows(List<T> rows) {
        this.rows = rows;
        return this;
    }
}

