/*
 * Decompiled with CFR 0.152.
 */
package com.xfw.work.util.event.local;

import com.xfw.work.util.event.base.EventListener;
import com.xfw.work.util.event.base.EventListenerMethod;
import com.xfw.work.util.event.base.EventListenerRegistry;
import com.xfw.work.util.event.local.Listen;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.util.CollectionUtils;

public class LocalEventListenerRegistry
implements EventListenerRegistry {
    private final ConcurrentHashMap<Class<?>, Set<EventListenerMethod>> listenerMethodMap = new ConcurrentHashMap();

    public void register(EventListener eventListener) {
        Map eventListenerMethodMap = this.findAllListenerMethods(eventListener);
        eventListenerMethodMap.forEach((eventType, listenerMethods) -> {
            HashSet eventMethods = (HashSet)this.listenerMethodMap.get(eventType);
            if (null == eventMethods) {
                eventMethods = new HashSet(listenerMethods);
                this.listenerMethodMap.put(eventType, eventMethods);
            } else {
                ((Set)this.listenerMethodMap.get(eventType)).addAll(listenerMethods);
            }
        });
    }

    public void unregister(EventListener eventListener) {
        Map eventListenerMethodMap = this.findAllListenerMethods(eventListener);
        if (CollectionUtils.isEmpty((Map)eventListenerMethodMap)) {
            throw new RuntimeException("Missing event listener for annotated method, type=" + eventListener.getClass().getName());
        }
        eventListenerMethodMap.forEach((eventType, listeners) -> {
            Set eventMethods = (Set)this.listenerMethodMap.get(eventType);
            if (null != eventMethods) {
                ((Set)this.listenerMethodMap.get(eventType)).removeAll(eventMethods);
            }
        });
    }

    public Set<EventListenerMethod> getListeners(Object event) {
        HashSet<EventListenerMethod> listeners = new HashSet<EventListenerMethod>();
        Class<?> clazz = event.getClass();
        Set eventListeners = (Set)this.listenerMethodMap.get(clazz);
        if (!CollectionUtils.isEmpty((Collection)eventListeners)) {
            listeners.addAll(eventListeners);
        }
        return listeners;
    }

    public Map<Class<?>, Set<EventListenerMethod>> findAllListenerMethods(EventListener eventListener) {
        HashMap classListenerMethodMap = new HashMap();
        Class<?> clazz = eventListener.getClass();
        List methods = this.getListenerMethodForClass(clazz);
        for (Method method : methods) {
            Class<?>[] parameterTypes = method.getParameterTypes();
            Class<?> eventType = parameterTypes[0];
            if (!classListenerMethodMap.containsKey(eventType)) {
                classListenerMethodMap.put(eventType, new HashSet());
            }
            EventListenerMethod eventListenerMethod = new EventListenerMethod(method, (Object)eventListener);
            ((Set)classListenerMethodMap.get(eventType)).add(eventListenerMethod);
        }
        return classListenerMethodMap;
    }

    private List<Method> getListenerMethodForClass(Class<?> clazz) {
        LinkedList queue = new LinkedList();
        ArrayList<Method> annotatedMethods = new ArrayList<Method>();
        queue.add(clazz);
        while (!queue.isEmpty()) {
            Class c = (Class)queue.poll();
            for (Method method : c.getDeclaredMethods()) {
                Listen annotation = method.getAnnotation(Listen.class);
                if (annotation == null) continue;
                annotatedMethods.add(method);
            }
            Class superclass = c.getSuperclass();
            if (superclass == null) continue;
            queue.add(superclass);
        }
        return annotatedMethods;
    }
}

