/*
 * Decompiled with CFR 0.152.
 */
package com.xfw.work.util.event.local;

import com.google.common.base.Preconditions;
import com.xfw.work.util.event.base.EventDispatcher;
import com.xfw.work.util.event.base.EventListenerMethod;
import com.xfw.work.util.event.base.ExceptionHandler;
import com.xfw.work.util.event.local.ExceptionContext;
import java.util.Iterator;
import java.util.concurrent.Executor;

public class LocalEventDispatcher
implements EventDispatcher {
    private final Executor executor;
    private final ExceptionHandler exceptionHandler;

    public LocalEventDispatcher(Executor executor, ExceptionHandler exceptionHandler) {
        this.executor = executor;
        this.exceptionHandler = exceptionHandler;
    }

    public void dispatcher(Object event, Iterator<EventListenerMethod> listeners) {
        Preconditions.checkNotNull((Object)event, (Object)"Event can't be null");
        listeners.forEachRemaining(listener -> this.executor.execute(() -> {
            try {
                listener.invokeMethod(event);
            }
            catch (Throwable e) {
                this.exceptionHandler.handleException(e, new ExceptionContext(event, listener.getTarget(), listener.getMethod()));
            }
        }));
    }
}

