/*
 * Decompiled with CFR 0.152.
 */
package com.xfw.work.util.event.local;

import com.xfw.work.util.event.base.ExceptionHandler;
import com.xfw.work.util.event.local.LocalEventDispatcher;
import com.xfw.work.util.event.local.LocalEventEngine;
import com.xfw.work.util.event.local.LocalEventListenerRegistry;
import com.xfw.work.util.event.local.LocalEventPublisher;
import com.xfw.work.util.event.local.LoggingExcepitonHandler;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class LocalEventAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(LocalEventAutoConfiguration.class);

    @Bean
    public LocalEventDispatcher localEventDispatcher(ExceptionHandler exceptionHandler) {
        return new LocalEventDispatcher((Executor)Executors.newCachedThreadPool(), exceptionHandler);
    }

    @Bean
    public LocalEventListenerRegistry localEventListenerRegistry() {
        return new LocalEventListenerRegistry();
    }

    @Bean
    public LocalEventEngine localEventEngine(LocalEventDispatcher dispatcher, LocalEventListenerRegistry registry) {
        return new LocalEventEngine(registry, dispatcher);
    }

    @Bean
    @ConditionalOnMissingBean(value={ExceptionHandler.class})
    public ExceptionHandler exceptionHandler() {
        return new LoggingExcepitonHandler();
    }

    @Bean
    public LocalEventPublisher eventPublisher(LocalEventEngine localEventEngine) {
        return new LocalEventPublisher(localEventEngine);
    }

    static /* synthetic */ Logger access$000() {
        return log;
    }
}

