/*
 * Decompiled with CFR 0.152.
 */
package com.xfw.work.util.event.base;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Objects;

public class EventListenerMethod {
    private Method method;
    private Object target;

    public void invokeMethod(Object event) throws InvocationTargetException {
        try {
            this.method.invoke(this.target, event);
        }
        catch (IllegalAccessException e) {
            throw new InvocationTargetException(e, "Method is not accessible");
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EventListenerMethod that = (EventListenerMethod)o;
        return Objects.equals(this.target, that.target) && Objects.equals(this.method, that.method);
    }

    public Method getMethod() {
        return this.method;
    }

    public Object getTarget() {
        return this.target;
    }

    public void setMethod(Method method) {
        this.method = method;
    }

    public void setTarget(Object target) {
        this.target = target;
    }

    public String toString() {
        return "EventListenerMethod(method=" + this.getMethod() + ", target=" + this.getTarget() + ")";
    }

    public EventListenerMethod(Method method, Object target) {
        this.method = method;
        this.target = target;
    }
}

