/*
 * Decompiled with CFR 0.152.
 */
package com.xfw.work.util;

import com.xfw.common.util.StringUtils;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.connection.RedisStringCommands;
import org.springframework.data.redis.core.Cursor;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.ScanOptions;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.core.types.Expiration;
import org.springframework.data.redis.serializer.JdkSerializationRedisSerializer;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class RedisUtil {
    private static final Logger log = LoggerFactory.getLogger(RedisUtil.class);
    @Resource
    private RedisTemplate<String, Object> redisTemplate;
    @Resource
    private StringRedisTemplate stringRedisTemplate;

    @Autowired(required=false)
    public void setRedisTemplate(RedisTemplate redisTemplate) {
        StringRedisSerializer stringSerializer = new StringRedisSerializer();
        redisTemplate.setKeySerializer((RedisSerializer)stringSerializer);
        redisTemplate.setValueSerializer((RedisSerializer)new JdkSerializationRedisSerializer());
        redisTemplate.setHashKeySerializer((RedisSerializer)stringSerializer);
        redisTemplate.setHashValueSerializer((RedisSerializer)stringSerializer);
        this.redisTemplate = redisTemplate;
    }

    public Boolean setIfAbsent(String key, String value, long time) {
        return this.redisTemplate.opsForValue().setIfAbsent((Object)key, (Object)value, time, TimeUnit.SECONDS);
    }

    public Boolean setIfAbsent(String key, String value) {
        return this.redisTemplate.opsForValue().setIfAbsent((Object)key, (Object)value);
    }

    public boolean expire(String key, long time) {
        try {
            if (time > 0L) {
                this.redisTemplate.expire((Object)key, time, TimeUnit.SECONDS);
            }
            return true;
        }
        catch (Exception e) {
            log.error("\u6307\u5b9a\u7f13\u5b58\u5931\u6548\u65f6\u95f4", (Throwable)e);
            return false;
        }
    }

    public boolean expireHour(String key, long time) {
        try {
            if (time > 0L) {
                this.redisTemplate.expire((Object)key, time, TimeUnit.HOURS);
            }
            return true;
        }
        catch (Exception e) {
            log.error("\u6307\u5b9a\u7f13\u5b58\u5931\u6548\u65f6\u95f4", (Throwable)e);
            return false;
        }
    }

    public long getExpire(String key) {
        if (StringUtils.isEmpty((CharSequence)key)) {
            return 0L;
        }
        return this.redisTemplate.getExpire((Object)key, TimeUnit.SECONDS);
    }

    public boolean hasKey(String key) {
        if (StringUtils.isEmpty((CharSequence)key)) {
            return false;
        }
        try {
            return this.redisTemplate.hasKey((Object)key);
        }
        catch (Exception e) {
            log.error("key\u662f\u5426\u5b58\u5728", (Throwable)e);
            return false;
        }
    }

    public void del(String ... key) {
        if (key != null && key.length > 0) {
            if (key.length == 1) {
                this.redisTemplate.delete((Object)key[0]);
            } else {
                this.redisTemplate.delete((Collection)CollectionUtils.arrayToList((Object)key));
            }
        }
    }

    public Object get(String key) {
        return key == null ? null : this.redisTemplate.opsForValue().get((Object)key);
    }

    public boolean set(String key, String value) {
        try {
            this.redisTemplate.opsForValue().set((Object)key, (Object)value);
            return true;
        }
        catch (Exception e) {
            log.error("\u666e\u901a\u7f13\u5b58\u653e\u5165", (Throwable)e);
            return false;
        }
    }

    public boolean set(String key, String value, long time) {
        try {
            if (time > 0L) {
                this.redisTemplate.opsForValue().set((Object)key, (Object)value, time, TimeUnit.SECONDS);
            } else {
                this.set(key, value);
            }
            return true;
        }
        catch (Exception e) {
            log.error("e.printStackTrace()", (Throwable)e);
            return false;
        }
    }

    public long incr(String key, long delta) {
        if (delta < 0L) {
            throw new RuntimeException("\u9012\u589e\u56e0\u5b50\u5fc5\u987b\u5927\u4e8e0");
        }
        return this.stringRedisTemplate.opsForValue().increment((Object)key, delta);
    }

    public Object getIncr(String key) {
        return this.stringRedisTemplate.opsForValue().get((Object)key);
    }

    public long decr(String key, long delta) {
        if (delta < 0L) {
            throw new RuntimeException("\u9012\u51cf\u56e0\u5b50\u5fc5\u987b\u5927\u4e8e0");
        }
        return this.redisTemplate.opsForValue().increment((Object)key, -delta);
    }

    public Set<String> getkeys(String key) {
        HashSet<String> set = new HashSet<String>();
        ScanOptions options = ScanOptions.scanOptions().match(key + "*").count(Integer.MAX_VALUE).build();
        RedisConnection redisConnection = this.redisTemplate.getConnectionFactory().getConnection();
        Cursor c = redisConnection.scan(options);
        while (c.hasNext()) {
            set.add(new String((byte[])c.next(), Charset.forName("utf-8")));
        }
        return set;
    }

    public long hincr(String key, String field, boolean isInit) {
        if (isInit) {
            this.hset(key, field, "0");
            return 0L;
        }
        return this.hincr(key, field, 1L);
    }

    public long hDecr(String key, String field) {
        return this.hDecr(key, field, 1L);
    }

    public long hincr(String key, String field, long value) {
        return this.redisTemplate.opsForHash().increment((Object)key, (Object)field, value);
    }

    public long hDecr(String key, String field, long value) {
        return this.redisTemplate.opsForHash().increment((Object)key, (Object)field, -value);
    }

    public void hset(String key, String field, String value) {
        this.redisTemplate.opsForHash().put((Object)key, (Object)field, (Object)value);
    }

    public String hget(String key, String field) {
        Object val = this.redisTemplate.opsForHash().get((Object)key, (Object)field);
        return val == null ? null : val.toString();
    }

    public void hdel(String key, String field) {
        this.redisTemplate.opsForHash().delete((Object)key, new Object[]{field});
    }

    public Map<String, String> hgetall(String key) {
        return (Map)this.redisTemplate.execute(con -> {
            Map result = con.hGetAll(key.getBytes());
            if (CollectionUtils.isEmpty((Map)result)) {
                return new HashMap(0);
            }
            HashMap<String, String> ans = new HashMap<String, String>(result.size());
            for (Map.Entry entry : result.entrySet()) {
                ans.put(new String((byte[])entry.getKey()), new String((byte[])entry.getValue()));
            }
            return ans;
        });
    }

    public void executePipelined(Map<String, String> map, long seconds) {
        RedisSerializer serializer = this.redisTemplate.getStringSerializer();
        this.redisTemplate.executePipelined(connection -> {
            map.forEach((key, value) -> connection.set(serializer.serialize(key), serializer.serialize(value), Expiration.seconds((long)seconds), RedisStringCommands.SetOption.UPSERT));
            return null;
        }, serializer);
    }

    public Map<String, String> hmget(String key, List<String> fields) {
        List result = this.redisTemplate.opsForHash().multiGet((Object)key, fields);
        HashMap<String, String> ans = new HashMap<String, String>(fields.size());
        int index = 0;
        for (String field : fields) {
            if (result.get(index) == null) continue;
            ans.put(field, (String)result.get(index));
        }
        return ans;
    }

    public Boolean setIfAbsentString(String key, String value, long time) {
        return this.stringRedisTemplate.opsForValue().setIfAbsent((Object)key, (Object)value, time, TimeUnit.SECONDS);
    }
}

