/*
 * Decompiled with CFR 0.152.
 */
package com.xfw.work.util;

import com.xfw.common.structure.Pair;
import com.xfw.common.util.StringUtils;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;

/*
 * Exception performing whole class analysis ignored.
 */
public class DateUtils {
    public static final String TIMEZONE = "GMT+8";
    public static final String DATE_TIME_PATTERN = "yyyy-MM-dd HH:mm:ss";
    public static final String MINUTE_PATTERN = "yyyy-MM-dd HH:mm";
    public static final String HOUR_PATTERN = "yyyy-MM-dd HH:mm:ss";
    public static final String DATE_PATTERN = "yyyy-MM-dd";
    public static final String YMD_PATTERN = "yyyyMMdd";
    public static final String MONTH_PATTERN = "yyyy-MM";
    public static final String YEAR_PATTERN = "yyyy";
    public static final String MINUTE_ONLY_PATTERN = "mm";
    public static final String HOUR_ONLY_PATTERN = "HH";
    public static final String MD_PATTERN = "MM-dd";
    public static final String DATE_WEEK_PATTERN = "yyyy\u5e74MM\u6708dd\u65e5 E HH:mm ";

    public static Date dateAdd(Date date, int days, boolean includeTime) throws ParseException {
        if (date == null) {
            date = new Date();
        }
        if (!includeTime) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            date = sdf.parse(sdf.format(date));
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(5, days);
        return cal.getTime();
    }

    public static String dateFormat(Date date, String pattern) throws ParseException {
        if (StringUtils.isBlank((CharSequence)pattern)) {
            pattern = "yyyy-MM-dd";
        }
        SimpleDateFormat sdf = new SimpleDateFormat(pattern);
        return sdf.format(date);
    }

    public static String dateFormat4DateAdd(Date date, int days, boolean includeTime, String pattern) throws ParseException {
        date = DateUtils.dateAdd((Date)date, (int)days, (boolean)includeTime);
        return DateUtils.dateFormat((Date)date, (String)pattern);
    }

    public static Date dateFormatBirthDate(String dateTimeString) throws ParseException {
        String pattern = (dateTimeString = dateTimeString.replaceAll("\\.", "-")).length() == 7 ? "yyyy-MM" : (dateTimeString.length() == 4 ? "yyyy" : "yyyy-MM-dd");
        SimpleDateFormat sdf = new SimpleDateFormat(pattern);
        sdf.setTimeZone(TimeZone.getTimeZone("GMT+8:00"));
        return sdf.parse(dateTimeString);
    }

    public static Date dateParse(String dateTimeString, String pattern) throws ParseException {
        if (StringUtils.isBlank((CharSequence)pattern)) {
            pattern = "yyyy-MM-dd";
        }
        SimpleDateFormat sdf = new SimpleDateFormat(pattern);
        return sdf.parse(dateTimeString);
    }

    public static String dateParseStrt(String dateTimeString, String pattern) throws ParseException {
        if (StringUtils.isBlank((CharSequence)pattern)) {
            pattern = "yyyy-MM-dd";
        }
        SimpleDateFormat sdf = new SimpleDateFormat(pattern);
        Date parse = sdf.parse(dateTimeString);
        SimpleDateFormat sdf2 = new SimpleDateFormat("yyyy-MM-dd");
        return sdf2.format(parse);
    }

    public static Date stringToDate(String str, String format) {
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        Date date = null;
        try {
            date = sdf.parse(str);
        }
        catch (ParseException var5) {
            var5.printStackTrace();
        }
        return date;
    }

    public static String dateTimeToDateString(Date dateTime) {
        String dateTimeString = null;
        try {
            dateTimeString = DateUtils.dateFormat((Date)dateTime, (String)"yyyy-MM-dd HH:mm:ss");
        }
        catch (ParseException e) {
            e.printStackTrace();
            return "";
        }
        return dateTimeString.substring(0, 10);
    }

    public static String dateToString(Date dateTime) {
        String dateTimeString = null;
        try {
            dateTimeString = DateUtils.dateFormat((Date)dateTime, (String)"yyyy-MM-dd HH:mm:ss");
        }
        catch (ParseException e) {
            e.printStackTrace();
            return "";
        }
        return dateTimeString;
    }

    public static String dateTimeToDateStringIfTimeEndZero(Date dateTime) throws ParseException {
        String dateTimeString = DateUtils.dateFormat((Date)dateTime, (String)"yyyy-MM-dd HH:mm:ss");
        if (dateTimeString.endsWith("00:00:00")) {
            return dateTimeString.substring(0, 10);
        }
        return dateTimeString;
    }

    public static Date dateTimeToDate(Date dateTime) throws ParseException {
        Calendar cal = Calendar.getInstance();
        cal.setTime(dateTime);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static Date dateAddHours(Date startDate, int hours) {
        if (startDate == null) {
            startDate = new Date();
        }
        Calendar c = Calendar.getInstance();
        c.setTime(startDate);
        c.set(10, c.get(10) + hours);
        return c.getTime();
    }

    public static Date dateAddMinutes(Date startDate, int minutes) {
        if (startDate == null) {
            startDate = new Date();
        }
        Calendar c = Calendar.getInstance();
        c.setTime(startDate);
        c.set(12, c.get(12) + minutes);
        return c.getTime();
    }

    public static Date getFirstDayOfMonth(int month) throws ParseException {
        Calendar cal = Calendar.getInstance();
        cal.set(2, month - 1);
        int firstDay = cal.getActualMinimum(5);
        cal.set(5, firstDay);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String firstDayOfMonth = sdf.format(cal.getTime()) + " 00:00:00";
        return sdf.parse(firstDayOfMonth);
    }

    public static Date getLastDayOfMonth(int month) throws ParseException {
        Calendar cal = Calendar.getInstance();
        cal.set(2, month - 1);
        int lastDay = 0;
        lastDay = month == 2 ? cal.getLeastMaximum(5) : cal.getActualMaximum(5);
        cal.set(5, lastDay);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String lastDayOfMonth = sdf.format(cal.getTime()) + " 23:59:59";
        SimpleDateFormat sdf2 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return sdf2.parse(lastDayOfMonth);
    }

    public static Date dateAddSeconds(Date startDate, int seconds) {
        if (startDate == null) {
            startDate = new Date();
        }
        Calendar c = Calendar.getInstance();
        c.setTime(startDate);
        c.set(13, c.get(13) + seconds);
        return c.getTime();
    }

    public static Date dateAddDays(Date startDate, int days) {
        if (startDate == null) {
            startDate = new Date();
        }
        Calendar c = Calendar.getInstance();
        c.setTime(startDate);
        c.set(5, c.get(5) + days);
        return c.getTime();
    }

    public static Date dateAddMonths(Date startDate, int months) {
        if (startDate == null) {
            startDate = new Date();
        }
        Calendar c = Calendar.getInstance();
        c.setTime(startDate);
        c.set(2, c.get(2) + months);
        return c.getTime();
    }

    public static Date dateAddYears(Date startDate, int years) {
        if (startDate == null) {
            startDate = new Date();
        }
        Calendar c = Calendar.getInstance();
        c.setTime(startDate);
        c.set(1, c.get(1) + years);
        return c.getTime();
    }

    public static int dateCompare(Date myDate, Date compareDate) {
        Calendar myCal = Calendar.getInstance();
        Calendar compareCal = Calendar.getInstance();
        myCal.setTime(myDate);
        compareCal.setTime(compareDate);
        return myCal.compareTo(compareCal);
    }

    public static Date dateMin(Date date, Date compareDate) {
        if (date == null) {
            return compareDate;
        }
        if (compareDate == null) {
            return date;
        }
        if (1 == DateUtils.dateCompare((Date)date, (Date)compareDate)) {
            return compareDate;
        }
        if (-1 == DateUtils.dateCompare((Date)date, (Date)compareDate)) {
            return date;
        }
        return date;
    }

    public static Date dateMax(Date date, Date compareDate) {
        if (date == null) {
            return compareDate;
        }
        if (compareDate == null) {
            return date;
        }
        if (1 == DateUtils.dateCompare((Date)date, (Date)compareDate)) {
            return date;
        }
        if (-1 == DateUtils.dateCompare((Date)date, (Date)compareDate)) {
            return compareDate;
        }
        return date;
    }

    public static int dateBetween(Date startDate, Date endDate) throws ParseException {
        Date dateStart = DateUtils.dateParse((String)DateUtils.dateFormat((Date)startDate, (String)"yyyy-MM-dd"), (String)"yyyy-MM-dd");
        Date dateEnd = DateUtils.dateParse((String)DateUtils.dateFormat((Date)endDate, (String)"yyyy-MM-dd"), (String)"yyyy-MM-dd");
        return (int)((dateEnd.getTime() - dateStart.getTime()) / 1000L / 60L / 60L / 24L);
    }

    public static int dateBetweenIncludeToday(Date startDate, Date endDate) throws ParseException {
        return DateUtils.dateBetween((Date)startDate, (Date)endDate) + 1;
    }

    public static int getYear(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal.get(1);
    }

    public static int getMonth(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal.get(2) + 1;
    }

    public static int getDate(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal.get(5);
    }

    public static int getDaysOfMonth(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal.getActualMaximum(5);
    }

    public static int getDaysOfYear(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal.getActualMaximum(6);
    }

    public static Date maxDateOfMonth(Date date) throws Exception {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int value = cal.getActualMaximum(5);
        return DateUtils.dateParse((String)(DateUtils.dateFormat((Date)date, (String)"yyyy-MM") + "-" + value), null);
    }

    public static Date minDateOfMonth(Date date) throws Exception {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int value = cal.getActualMinimum(5);
        return DateUtils.dateParse((String)(DateUtils.dateFormat((Date)date, (String)"yyyy-MM") + "-" + value), null);
    }

    public static Date getTimesmorning(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(cal.get(1), cal.get(2), cal.get(5), 0, 0, 0);
        Date beginOfDate = cal.getTime();
        return beginOfDate;
    }

    public static Date getTimesNight(Date date) {
        return DateUtils.dateAddSeconds((Date)DateUtils.dateAddDays((Date)DateUtils.getTimesmorning((Date)date), (int)1), (int)-1);
    }

    public static void main(String[] args) {
        Date date = DateUtils.stringToDate((String)"2022-01-02 00:00:00", (String)"yyyy-MM-dd");
        Date date2 = DateUtils.stringToDate((String)"2022-03-09 00:00:00", (String)"yyyy-MM-dd");
        List days4Week = DateUtils.getDays4Week((Date)date, (Date)date2);
    }

    public static Date getWeekStart() throws ParseException {
        Calendar cal = Calendar.getInstance();
        cal.add(4, 0);
        cal.set(7, 2);
        Date time = cal.getTime();
        String startTime = new SimpleDateFormat("yyyy-MM-dd").format(time) + " 00:00:00";
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return sdf.parse(startTime);
    }

    public static Date getWeekEnd() throws ParseException {
        Calendar cal = Calendar.getInstance();
        cal.set(7, cal.getActualMaximum(7));
        cal.add(7, 1);
        Date time = cal.getTime();
        String endTime = new SimpleDateFormat("yyyy-MM-dd").format(time) + " 23:59:59";
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return sdf.parse(endTime);
    }

    public static List<String> getDays(Date firstTime, Date lastTime) {
        ArrayList<String> days = new ArrayList<String>();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        try {
            Calendar tempStart = Calendar.getInstance();
            tempStart.setTime(firstTime);
            String startTime = dateFormat.format(Calendar.getInstance().getTime());
            Calendar tempEnd = Calendar.getInstance();
            tempEnd.setTime(lastTime);
            String endTime = dateFormat.format(tempEnd.getTime());
            while (!tempStart.after(tempEnd)) {
                days.add(dateFormat.format(tempStart.getTime()));
                tempStart.add(6, 1);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return days;
    }

    public static List<Pair<String, String>> getDays4Week(Date firstTime, Date lastTime) {
        ArrayList<Pair<String, String>> data = new ArrayList<Pair<String, String>>();
        ArrayList<String> allDays = new ArrayList<String>();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        try {
            Calendar tempStart = Calendar.getInstance();
            tempStart.setTime(firstTime);
            Calendar tempEnd = Calendar.getInstance();
            tempEnd.setTime(lastTime);
            while (!tempStart.after(tempEnd)) {
                allDays.add(dateFormat.format(tempStart.getTime()));
                tempStart.add(6, 1);
            }
            List lists = DateUtils.splistList(allDays, (int)7);
            for (List days : lists) {
                if (days.size() > 1) {
                    data.add((Pair<String, String>)Pair.create(days.get(0), days.get(days.size() - 1)));
                    continue;
                }
                data.add((Pair<String, String>)Pair.create(days.get(0), days.get(0)));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return data;
    }

    public static <T> List<List<T>> splistList(List<T> list, int subNum) {
        ArrayList<List<T>> tNewList = new ArrayList<List<T>>();
        int priIndex = 0;
        int lastPriIndex = 0;
        int insertTimes = list.size() / subNum;
        List<Object> subList = new ArrayList();
        for (int i = 0; i <= insertTimes; ++i) {
            priIndex = subNum * i;
            lastPriIndex = priIndex + subNum;
            subList = i == insertTimes ? list.subList(priIndex, list.size()) : list.subList(priIndex, lastPriIndex);
            if (subList.size() <= 0) continue;
            tNewList.add(subList);
        }
        return tNewList;
    }

    public static List<String> getBetweenMonths(Date start, Date end) {
        ArrayList<String> result = new ArrayList<String>();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM");
        Calendar tempStart = Calendar.getInstance();
        tempStart.setTime(start);
        tempStart.add(2, 1);
        Calendar tempEnd = Calendar.getInstance();
        tempEnd.setTime(end);
        result.add(sdf.format(start));
        while (tempStart.before(tempEnd)) {
            result.add(sdf.format(tempStart.getTime()));
            tempStart.add(2, 1);
        }
        return result;
    }

    public static Date getThisWeekMonday() {
        LocalDate today = LocalDate.now();
        LocalDate toweekMonday = today.with(DayOfWeek.MONDAY);
        ZonedDateTime zonedDateTime = toweekMonday.atStartOfDay(ZoneId.systemDefault());
        return Date.from(zonedDateTime.toInstant());
    }

    public static String getToday() {
        return new SimpleDateFormat("yyyy-MM-dd").format(new Date());
    }

    public static String getNowDate() {
        return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date());
    }

    public static String getNowDateWeek() {
        return new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5 E HH:mm ", Locale.CHINA).format(new Date());
    }
}

