/*
 * Decompiled with CFR 0.152.
 */
package com.xfw.work.service.impl;

import com.xfw.common.concurrent.ThreadPoolManager;
import com.xfw.dingtalk.contacts.dao.UserMapper;
import com.xfw.dingtalk.contacts.model.bo.user.UserLoginBO;
import com.xfw.dingtalk.contacts.model.entity.User;
import com.xfw.dingtalk.contacts.service.foreign.DingTalkUserService;
import com.xfw.dingtalk.contacts.service.sync.ContactService;
import com.xfw.work.config.interceptor.AuthenticationInterceptor;
import com.xfw.work.model.bo.UserBO;
import com.xfw.work.model.common.SessionUser;
import com.xfw.work.model.param.UserLoginParam;
import com.xfw.work.service.UserService;
import com.xfw.work.util.RedisUtil;
import com.xfw.work.util.SessionManager;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UserServiceImpl
implements UserService {
    @Autowired
    private DingTalkUserService dingTalkUserService;
    @Resource
    private UserMapper userMapper;
    @Autowired
    private ContactService contactService;
    @Autowired
    private RedisUtil redisUtil;

    public UserBO login(HttpServletRequest request, UserLoginParam loginParam) {
        UserLoginBO userLoginBO = this.dingTalkUserService.userAuthIgnore(loginParam.getCorpId(), loginParam.getCode());
        UserBO userBO = new UserBO();
        BeanUtils.copyProperties((Object)userLoginBO, (Object)userBO);
        String token = AuthenticationInterceptor.getToken((UserBO)userBO);
        userBO.setToken(token);
        this.redisUtil.set("work:login:user:" + userBO.getUserId(), token, 43200L);
        return userBO;
    }

    public UserBO getUserById(Long companyId, Long userId) {
        User user = this.userMapper.getUser(userId, null);
        UserBO bo = new UserBO();
        bo.setUserId(user.getId());
        bo.setCompanyId(user.getCompanyId());
        bo.setUsername(user.getName());
        bo.setDingUserId(user.getDingUserId());
        bo.setCorpId(user.getCorpId());
        bo.setAvatar(user.getAvatar());
        bo.setUnionid(user.getUnionid());
        return bo;
    }

    public void synCompany() {
        SessionUser sessionUser = SessionManager.getSessionUser();
        ThreadPoolManager.addExecuteTask(() -> this.contactService.async(sessionUser.getCorpId(), sessionUser.getDingUserId()));
    }
}

