/*
 * Decompiled with CFR 0.152.
 */
package com.xfw.work.service.impl;

import com.xfw.common.exception.BusinessException;
import com.xfw.common.util.AssertUtils;
import com.xfw.common.util.CollectionUtils;
import com.xfw.common.util.IDGenerator;
import com.xfw.work.model.common.SessionUser;
import com.xfw.work.model.entity.PsychologicalCounseling;
import com.xfw.work.model.param.PsychologicalCounselingParam;
import com.xfw.work.model.vo.PsychologicalCounselingDetailVO;
import com.xfw.work.model.vo.PsychologicalCounselingListVO;
import com.xfw.work.persistence.mapper.PsychologicalCounselingMapper;
import com.xfw.work.service.PsychologicalCounselingService;
import com.xfw.work.util.DateUtils;
import com.xfw.work.util.SessionManager;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.assertj.core.util.Lists;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import tk.mybatis.mapper.entity.Example;

@Service
public class PsychologicalCounselingServiceImpl
implements PsychologicalCounselingService {
    @Resource
    private PsychologicalCounselingMapper psychologicalCounselingMapper;

    public String save(PsychologicalCounselingParam param) {
        SessionUser sessionUser = SessionManager.getSessionUser();
        PsychologicalCounseling psy = new PsychologicalCounseling();
        BeanUtils.copyProperties((Object)param, (Object)psy);
        Long id = IDGenerator.getId();
        psy.setId(id);
        psy.setCompanyId(sessionUser.getCompanyId());
        psy.setCreateUserId(sessionUser.getUserId());
        psy.setUnionid(sessionUser.getUnionid());
        psy.setGmtCreate(new Date());
        this.psychologicalCounselingMapper.insertSelective((Object)psy);
        return id.toString();
    }

    public List<PsychologicalCounselingListVO> getRecord() {
        SessionUser sessionUser = SessionManager.getSessionUser();
        Example example = new Example(PsychologicalCounseling.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("unionid", (Object)sessionUser.getUnionid());
        example.setOrderByClause("gmt_create desc");
        List data = this.psychologicalCounselingMapper.selectByExample((Object)example);
        if (CollectionUtils.isEmpty((Collection)data)) {
            return Lists.newArrayList();
        }
        return data.stream().map(arg_0 -> this.packageListVO(arg_0)).collect(Collectors.toList());
    }

    public PsychologicalCounselingDetailVO getDetail(Long id) {
        SessionUser sessionUser = SessionManager.getSessionUser();
        PsychologicalCounseling psychologicalCounseling = (PsychologicalCounseling)this.psychologicalCounselingMapper.selectByPrimaryKey((Object)id);
        AssertUtils.notNull((Object)psychologicalCounseling, (String)"\u6570\u636e\u4e0d\u5b58\u5728");
        if (!psychologicalCounseling.getUnionid().equals(sessionUser.getUnionid())) {
            throw new BusinessException("\u975e\u672c\u4eba\u6570\u636e");
        }
        PsychologicalCounselingDetailVO vo = new PsychologicalCounselingDetailVO();
        BeanUtils.copyProperties((Object)psychologicalCounseling, (Object)vo);
        vo.setSubmitDate(DateUtils.dateToString((Date)psychologicalCounseling.getGmtCreate()));
        return vo;
    }

    private PsychologicalCounselingListVO packageListVO(PsychologicalCounseling psy) {
        PsychologicalCounselingListVO vo = new PsychologicalCounselingListVO();
        BeanUtils.copyProperties((Object)psy, (Object)vo);
        vo.setSubmitDate(DateUtils.dateToString((Date)psy.getGmtCreate()));
        return vo;
    }
}

