/*
 * Decompiled with CFR 0.152.
 */
package com.xfw.work.service.impl;

import com.aliyun.oss.model.ObjectMetadata;
import com.xfw.work.config.OssConfig;
import com.xfw.work.model.enums.OssUploadFileTypeEnum;
import com.xfw.work.service.OssUploadService;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.UUID;
import org.apache.http.client.utils.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class OssUploadServiceImpl
implements OssUploadService {
    private static final Logger log = LoggerFactory.getLogger(OssUploadServiceImpl.class);
    @Autowired
    private OssConfig ossConfig;

    public String upload(String fileExtension, Integer fileType, ByteArrayInputStream byteArrayInputStream) {
        String objectFileName = this.getObjectFileName(OssUploadFileTypeEnum.getNameByType((Integer)fileType), fileExtension);
        ObjectMetadata objectMetadataPic = new ObjectMetadata();
        objectMetadataPic.setContentType(OssUploadServiceImpl.getContentType((String)fileExtension));
        this.ossConfig.oSSClient().putObject(this.ossConfig.getBucketName(), objectFileName, (InputStream)byteArrayInputStream, objectMetadataPic);
        return this.ossConfig.getFilePath() + objectFileName;
    }

    public String upload(String fileName, String fileExtension, Integer fileType, ByteArrayInputStream byteArrayInputStream) {
        String objectFileName = this.getObjectFileSpecifyName(OssUploadFileTypeEnum.getNameByType((Integer)fileType), fileName, fileExtension);
        ObjectMetadata objectMetadataPic = new ObjectMetadata();
        objectMetadataPic.setContentType(OssUploadServiceImpl.getContentType((String)fileExtension));
        this.ossConfig.oSSClient().putObject(this.ossConfig.getBucketName(), objectFileName, (InputStream)byteArrayInputStream, objectMetadataPic);
        return this.ossConfig.getFilePath() + objectFileName;
    }

    public static String getContentType(String fileExtension) {
        HashMap<String, String> map = new HashMap<String, String>(8);
        map.put("jpeg", "image/jpeg");
        map.put("jpg", "image/jpg");
        map.put("png", "image/png");
        map.put("doc", "application/msword");
        map.put("docx", "application/msword");
        map.put("pdf", "application/pdf");
        return (String)map.get(fileExtension.toLowerCase());
    }

    private String getObjectFileName(String fileTypeName, String fileExtension) {
        return "work/" + fileTypeName + "/" + DateUtils.formatDate((Date)new Date(), (String)"yyyy-MM") + "/" + UUID.randomUUID().toString() + "." + fileExtension;
    }

    private String getObjectFileSpecifyName(String fileTypeName, String specifyName, String fileExtension) {
        return "work/" + fileTypeName + "/" + specifyName + "." + fileExtension;
    }
}

