/*
 * Decompiled with CFR 0.152.
 */
package com.xfw.work.service.impl;

import com.xfw.dingtalk.contacts.dao.UserDepartmentMapper;
import com.xfw.work.model.common.SessionUser;
import com.xfw.work.model.entity.GiftPackGetInfo;
import com.xfw.work.model.param.AreaParam;
import com.xfw.work.model.param.GiftPackGetParam;
import com.xfw.work.model.vo.QueryAddressListVO;
import com.xfw.work.persistence.mapper.GiftPackDeptListMapper;
import com.xfw.work.persistence.mapper.GiftPackGetInfoMapper;
import com.xfw.work.service.impl.AreaService;
import com.xfw.work.util.SessionManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class GiftPackService {
    @Resource
    private GiftPackDeptListMapper giftPackDeptListMapper;
    @Resource
    private GiftPackGetInfoMapper giftPackGetInfoMapper;
    @Resource
    private AreaService areaService;
    @Resource
    private UserDepartmentMapper userDepartmentMapper;

    public Boolean get(GiftPackGetParam param) {
        Boolean canGet = this.checkCanGet(param);
        if (!canGet.booleanValue()) {
            return false;
        }
        SessionUser sessionUser = SessionManager.getSessionUser();
        GiftPackGetInfo giftPackGetInfo = new GiftPackGetInfo();
        BeanUtils.copyProperties((Object)param, (Object)giftPackGetInfo);
        AreaParam areaParam = new AreaParam();
        HashSet<Long> codes = new HashSet<Long>();
        if (Objects.nonNull(param.getProvince())) {
            codes.add(param.getProvince());
        }
        if (Objects.nonNull(param.getCity())) {
            codes.add(param.getCity());
        }
        if (Objects.nonNull(param.getCounty())) {
            codes.add(param.getCounty());
        }
        if (Objects.nonNull(param.getTown())) {
            codes.add(param.getTown());
        }
        areaParam.setCodes(codes);
        Map<Long, String> areaMap = this.areaService.getAreaListByCode(areaParam).getAddresses().stream().collect(Collectors.toMap(QueryAddressListVO.Address::getCode, QueryAddressListVO.Address::getName));
        giftPackGetInfo.setUnionId(sessionUser.getUserId().toString());
        giftPackGetInfo.setProvinceName(areaMap.get(param.getProvince()));
        giftPackGetInfo.setCityName(areaMap.get(param.getCity()));
        giftPackGetInfo.setCountyName(areaMap.get(param.getCounty()));
        giftPackGetInfo.setTownName(areaMap.get(param.getTown()));
        this.giftPackGetInfoMapper.insert((Object)giftPackGetInfo);
        return true;
    }

    public List<Integer> hasGiftInfo() {
        SessionUser sessionUser = SessionManager.getSessionUser();
        Long userId = Optional.ofNullable(sessionUser).map(SessionUser::getUserId).orElse(null);
        if (Objects.isNull(userId)) {
            return new ArrayList<Integer>();
        }
        List getInfos = this.giftPackGetInfoMapper.selectListByUnionId(userId.toString());
        return getInfos.stream().map(GiftPackGetInfo::getGiftId).distinct().collect(Collectors.toList());
    }

    public List<Long> getWhiteDeptIds() {
        return this.giftPackDeptListMapper.selectAllDeptIds();
    }

    public Boolean checkCanGet(GiftPackGetParam param) {
        SessionUser sessionUser = SessionManager.getSessionUser();
        Long userId = Optional.ofNullable(sessionUser).map(SessionUser::getUserId).orElse(null);
        if (Objects.isNull(userId)) {
            return false;
        }
        Long count = this.giftPackGetInfoMapper.selectCountByUnionId(userId.toString());
        if (count > 0L) {
            return false;
        }
        return this.isInWhiteDept(sessionUser.getCompanyId(), sessionUser.getUserId());
    }

    public Boolean isInWhiteDept(Long companyId, Long userId) {
        List whiteDeptIds = this.getWhiteDeptIds();
        if (CollectionUtils.isEmpty((Collection)whiteDeptIds)) {
            return false;
        }
        List userDepartmentIds = this.userDepartmentMapper.findUserDepartmentIdListByDB(companyId, userId);
        if (CollectionUtils.isEmpty((Collection)userDepartmentIds)) {
            return false;
        }
        boolean hasIntersection = whiteDeptIds.stream().anyMatch(x -> userDepartmentIds.contains(x));
        return hasIntersection;
    }
}

