/*
 * Decompiled with CFR 0.152.
 */
package com.xfw.work.service.impl;

import com.xfw.common.util.IDGenerator;
import com.xfw.work.model.bo.FileBO;
import com.xfw.work.model.common.SessionUser;
import com.xfw.work.model.entity.UploadFile;
import com.xfw.work.model.param.UploadOssParam;
import com.xfw.work.persistence.mapper.UploadFileMapper;
import com.xfw.work.service.FileService;
import com.xfw.work.service.OssUploadService;
import com.xfw.work.util.SessionManager;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class FileServiceImpl
implements FileService {
    private static final Logger log = LoggerFactory.getLogger(FileServiceImpl.class);
    @Autowired
    private OssUploadService ossUploadService;
    @Autowired
    private UploadFileMapper uploadFileMapper;

    public FileBO uploadOss(UploadOssParam uploadOssParam) {
        MultipartFile file = null;
        String fileExtension = null;
        String path = null;
        try {
            file = uploadOssParam.getFile();
            String fileName = file.getOriginalFilename();
            byte[] content = file.getBytes();
            assert (fileName != null);
            fileExtension = fileName.substring(fileName.lastIndexOf(".") + 1);
            path = this.ossUploadService.upload(fileExtension, uploadOssParam.getFileType(), new ByteArrayInputStream(content));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        SessionUser sessionUser = SessionManager.getSessionUser();
        return this.saveFileData(file, path, fileExtension, sessionUser);
    }

    public FileBO saveFileData(MultipartFile file, String path, String fileExtension, SessionUser sessionUser) {
        UploadFile uploadFile = new UploadFile();
        Long fileId = IDGenerator.getId();
        Date sysDate = new Date();
        uploadFile.setId(fileId);
        uploadFile.setGmtCreate(sysDate);
        uploadFile.setCreateUserId(sessionUser.getUserId());
        uploadFile.setCompanyId(sessionUser.getCompanyId());
        uploadFile.setName(file.getOriginalFilename());
        uploadFile.setPath(path);
        uploadFile.setSize(Long.valueOf(file.getSize()));
        uploadFile.setFormat(fileExtension);
        uploadFile.setIsDelete(Boolean.valueOf(false));
        this.uploadFileMapper.insertSelective((Object)uploadFile);
        FileBO fileBO = new FileBO();
        fileBO.setFileId(fileId);
        fileBO.setFilePath(path);
        return fileBO;
    }
}

