/*
 * Decompiled with CFR 0.152.
 */
package com.xfw.work.service.impl;

import com.xfw.common.exception.BusinessException;
import com.xfw.common.util.IDGenerator;
import com.xfw.work.listener.BpEvent;
import com.xfw.work.model.entity.BpRecord;
import com.xfw.work.model.entity.BpReport;
import com.xfw.work.model.param.BpParam;
import com.xfw.work.persistence.mapper.BpRecordMapper;
import com.xfw.work.persistence.mapper.BpReportMapper;
import com.xfw.work.service.BpService;
import com.xfw.work.util.RedisUtil;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import tk.mybatis.mapper.entity.Example;

@Service
public class BpServiceImpl
implements BpService {
    @Resource
    private BpRecordMapper bpRecordMapper;
    @Resource
    private BpReportMapper bpReportMapper;
    @Resource
    private RedisUtil redisUtil;

    public void upload(BpEvent event) {
        BpRecord bpRecord = new BpRecord();
        BeanUtils.copyProperties((Object)event, (Object)bpRecord);
        bpRecord.setGmtCreate(new Date());
        bpRecord.setId(IDGenerator.getId());
        this.bpRecordMapper.insert((Object)bpRecord);
        this.updateReport(event);
    }

    public Map<Long, Integer> getDataMap(BpParam param) {
        List bpReports;
        Example example = new Example(BpReport.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("type", (Object)param.getType());
        if (Objects.nonNull(param.getBpId())) {
            criteria.andEqualTo("bpId", (Object)param.getBpId());
        }
        if (CollectionUtils.isEmpty((Collection)(bpReports = this.bpReportMapper.selectByExample((Object)example)))) {
            return new HashMap<Long, Integer>();
        }
        try {
            Map<Long, Integer> productPriceMap = bpReports.stream().collect(Collectors.toMap(k -> k.getBpId(), j -> j.getPv()));
            return productPriceMap;
        }
        catch (Exception e) {
            return new HashMap<Long, Integer>();
        }
    }

    private void updateReport(BpEvent event) {
        String key;
        block7: {
            Example example = new Example(BpReport.class);
            Example.Criteria criteria = example.createCriteria();
            criteria.andEqualTo("type", (Object)event.getType());
            if (Objects.nonNull(event.getBpId())) {
                criteria.andEqualTo("bpId", (Object)event.getBpId());
            }
            key = String.format("bp:report:type:%s:bpId:%s", event.getType(), Objects.nonNull(event.getBpId()) ? event.getBpId() : "none");
            while (!this.redisUtil.setIfAbsent(key, "running", 20L).booleanValue()) {
            }
            try {
                List bpReports = this.bpReportMapper.selectByExample((Object)example);
                if (CollectionUtils.isEmpty((Collection)bpReports)) {
                    BpReport bpReport = new BpReport();
                    bpReport.setBpId(event.getBpId());
                    bpReport.setType(event.getType());
                    bpReport.setPv(Integer.valueOf(1));
                    bpReport.setId(IDGenerator.getId());
                    this.bpReportMapper.insert((Object)bpReport);
                    break block7;
                }
                BpReport bpReport = (BpReport)bpReports.get(0);
                BpReport updateRp = new BpReport();
                updateRp.setId(bpReport.getId());
                updateRp.setPv(Integer.valueOf(bpReport.getPv() + 1));
                this.bpReportMapper.updateByPrimaryKeySelective((Object)updateRp);
            }
            catch (Exception e) {
                try {
                    throw new BusinessException("\u63d2\u5165\u57cb\u70b9\u7edf\u8ba1\u6570\u636e\u5931\u8d25");
                }
                catch (Throwable throwable) {
                    this.redisUtil.del(new String[]{key});
                }
            }
        }
        this.redisUtil.del(new String[]{key});
    }
}

