/*
 * Decompiled with CFR 0.152.
 */
package com.xfw.work.service.impl;

import com.xfw.work.model.param.AreaParam;
import com.xfw.work.model.vo.QueryAddressListVO;
import com.xfw.work.persistence.mapper.AreaDictionaryMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class AreaService {
    @Resource
    private AreaDictionaryMapper areaDictionaryMapper;

    public QueryAddressListVO getAreaList(AreaParam param) {
        List areaDictionary = this.areaDictionaryMapper.selectListByParentId(Optional.ofNullable(param.getParentId()).orElse(1L));
        List addresses = areaDictionary.stream().map(area -> {
            QueryAddressListVO.Address address = new QueryAddressListVO.Address();
            BeanUtils.copyProperties((Object)area, (Object)address);
            return address;
        }).collect(Collectors.toList());
        QueryAddressListVO response = new QueryAddressListVO();
        response.setAddresses(addresses);
        return response;
    }

    public QueryAddressListVO getAreaListByCode(AreaParam param) {
        QueryAddressListVO response = new QueryAddressListVO();
        response.setAddresses(new ArrayList());
        Set codes = Optional.ofNullable(param).map(AreaParam::getCodes).orElse(new HashSet());
        if (CollectionUtils.isEmpty((Collection)codes)) {
            return response;
        }
        List areaDictionary = this.areaDictionaryMapper.selectListByCodes(codes);
        List addresses = areaDictionary.stream().map(area -> {
            QueryAddressListVO.Address address = new QueryAddressListVO.Address();
            BeanUtils.copyProperties((Object)area, (Object)address);
            return address;
        }).collect(Collectors.toList());
        response.setAddresses(addresses);
        return response;
    }
}

