/*
 * Decompiled with CFR 0.152.
 */
package com.xfw.work.service.impl;

import com.xfw.common.exception.BusinessException;
import com.xfw.common.util.AssertUtils;
import com.xfw.common.util.CollectionUtils;
import com.xfw.common.util.IDGenerator;
import com.xfw.work.model.common.SessionUser;
import com.xfw.work.model.entity.AdvicePlan;
import com.xfw.work.model.param.AdvicePlanParam;
import com.xfw.work.model.vo.AdvicePlanDetailVO;
import com.xfw.work.model.vo.AdvicePlanListVO;
import com.xfw.work.persistence.mapper.AdvicePlanMapper;
import com.xfw.work.service.AdvicePlanService;
import com.xfw.work.util.DateUtils;
import com.xfw.work.util.SessionManager;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.assertj.core.util.Lists;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import tk.mybatis.mapper.entity.Example;

@Service
public class AdvicePlanServiceImpl
implements AdvicePlanService {
    @Resource
    private AdvicePlanMapper advicePlanMapper;

    public Long submit(AdvicePlanParam param) {
        SessionUser sessionUser = SessionManager.getSessionUser();
        AdvicePlan plan = new AdvicePlan();
        BeanUtils.copyProperties((Object)param, (Object)plan);
        plan.setId(IDGenerator.getId());
        plan.setCompanyId(sessionUser.getCompanyId());
        plan.setCreateUserId(sessionUser.getUserId());
        plan.setUnionid(sessionUser.getUnionid());
        plan.setGmtCreate(new Date());
        this.advicePlanMapper.insertSelective((Object)plan);
        return plan.getId();
    }

    public List<AdvicePlanListVO> getHistory() {
        SessionUser sessionUser = SessionManager.getSessionUser();
        Example example = new Example(AdvicePlan.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("unionid", (Object)sessionUser.getUnionid());
        List data = this.advicePlanMapper.selectByExample((Object)example);
        if (CollectionUtils.isEmpty((Collection)data)) {
            return Lists.newArrayList();
        }
        return data.stream().map(arg_0 -> this.packageListVO(arg_0)).collect(Collectors.toList());
    }

    public AdvicePlanDetailVO getDetail(Long id) {
        SessionUser sessionUser = SessionManager.getSessionUser();
        AdvicePlan advicePlan = (AdvicePlan)this.advicePlanMapper.selectByPrimaryKey((Object)id);
        AssertUtils.notNull((Object)advicePlan, (String)"\u6570\u636e\u4e0d\u5b58\u5728");
        if (!advicePlan.getUnionid().equals(sessionUser.getUnionid())) {
            throw new BusinessException("\u975e\u672c\u4eba\u6570\u636e");
        }
        AdvicePlanDetailVO advicePlanDetailVO = new AdvicePlanDetailVO();
        BeanUtils.copyProperties((Object)advicePlan, (Object)advicePlanDetailVO);
        advicePlanDetailVO.setSubmitDate(DateUtils.dateTimeToDateString((Date)advicePlan.getGmtCreate()));
        return advicePlanDetailVO;
    }

    private AdvicePlanListVO packageListVO(AdvicePlan plan) {
        AdvicePlanListVO advicePlanListVO = new AdvicePlanListVO();
        BeanUtils.copyProperties((Object)plan, (Object)advicePlanListVO);
        advicePlanListVO.setSubmitDate(DateUtils.dateTimeToDateString((Date)plan.getGmtCreate()));
        return advicePlanListVO;
    }
}

