/*
 * Decompiled with CFR 0.152.
 */
package com.xfw.work.model.common;

import com.xfw.work.model.common.ServiceCode;
import java.io.Serializable;

public class ServiceResult<T>
implements Serializable {
    private static final long serialVersionUID = 1340563394201259857L;
    protected boolean success;
    protected String errorCode;
    protected String errorMsg;
    protected T result;
    protected Object[] arguments;

    public Object[] getArguments() {
        return this.arguments;
    }

    public void setArguments(Object[] arguments) {
        this.arguments = arguments;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    public String getErrorMsg() {
        return this.errorMsg;
    }

    public void setErrorMsg(String errorMsg) {
        this.errorMsg = errorMsg;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public T getResult() {
        return (T)this.result;
    }

    public void setResult(T result) {
        this.result = result;
    }

    public static <T> ServiceResult<T> getSuccessResult(T v) {
        ServiceResult result = new ServiceResult();
        result.setSuccess(true);
        result.setResult(v);
        return result;
    }

    public static <T> ServiceResult<T> getSuccessResult() {
        ServiceResult result = new ServiceResult();
        result.setSuccess(true);
        return result;
    }

    public static <T> ServiceResult<T> getFailureResult(String errorCode, String msg) {
        ServiceResult result = new ServiceResult();
        result.setSuccess(false);
        result.setErrorCode(errorCode);
        result.setErrorMsg(msg);
        return result;
    }

    public static <T> ServiceResult<T> getFailureResult(String errorCode, String msg, T v) {
        ServiceResult result = new ServiceResult();
        result.setSuccess(false);
        result.setErrorCode(errorCode);
        result.setErrorMsg(msg);
        result.setResult(v);
        return result;
    }

    public static <T> ServiceResult<T> getFailureResult(String msg) {
        ServiceResult result = new ServiceResult();
        result.setSuccess(false);
        result.setErrorCode(ServiceCode.SERVER_ERROR.getCode());
        result.setErrorMsg(msg);
        return result;
    }

    public static <T> ServiceResult<T> getFailureResult() {
        ServiceResult result = new ServiceResult();
        result.setSuccess(false);
        result.setErrorCode(ServiceCode.SERVER_ERROR.getCode());
        return result;
    }
}

