/*
 * Decompiled with CFR 0.152.
 */
package com.xfw.work.handler;

import com.xfw.work.model.common.ServiceException;
import com.xfw.work.model.common.ServiceResult;
import com.xfw.work.model.common.TokenException;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;

@RestControllerAdvice
public class CustomerGlobalExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(CustomerGlobalExceptionHandler.class);

    @ExceptionHandler(value={ServiceException.class})
    public ServiceResult<Objects> serviceExceptionHandler(HttpServletRequest req, ServiceException e) {
        log.error("\u5904\u7406\u81ea\u5b9a\u4e49\u7684service\u5f02\u5e38", (Throwable)e);
        return ServiceResult.getFailureResult((String)e.getErrorCode(), (String)e.getMessage());
    }

    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    public ServiceResult<Object> handleMethodArgumentNotValidExceptionHandler(MethodArgumentNotValidException e) {
        log.error("\u53c2\u6570\u6821\u9a8c\u5f02\u5e38: " + e.getMessage(), (Throwable)e);
        return ServiceResult.getFailureResult((String)Objects.requireNonNull(e.getBindingResult().getFieldError()).getDefaultMessage());
    }

    @ExceptionHandler(value={TokenException.class})
    public ServiceResult<Objects> tokenExceptionHandler(HttpServletRequest req, TokenException e) {
        log.error("TokenException", (Throwable)e);
        return ServiceResult.getFailureResult((String)String.valueOf(e.getCode()), (String)e.getMessage());
    }

    @ExceptionHandler(value={Exception.class})
    public ServiceResult<Objects> serviceExceptionHandler(HttpServletRequest req, Exception e) {
        log.error("Exception\u5f02\u5e38", (Throwable)e);
        return ServiceResult.getFailureResult((String)e.getMessage());
    }
}

