/*
 * Decompiled with CFR 0.152.
 */
package com.xfw.work.controller.dingsynchttp;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.dingtalk.oapi.lib.aes.DingTalkEncryptor;
import com.google.common.collect.Lists;
import com.xfw.common.util.BeanUtils;
import com.xfw.dingtalk.common.model.entity.OpenSyncBizData;
import com.xfw.dingtalk.common.model.entity.OpenSyncBizDataMedium;
import com.xfw.dingtalk.dps.config.database.DynamicDataSource;
import com.xfw.dingtalk.dps.dao.OpenSyncBizDataMapper;
import com.xfw.dingtalk.dps.dao.OpenSyncBizDataMediumMapper;
import com.xfw.web.jsckson.JsonUtil;
import com.xfw.work.config.annotation.NotNeedLogin;
import com.xfw.work.config.annotation.PassToken;
import com.xfw.work.model.common.ServiceResult;
import com.xfw.work.service.TestService;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/"})
public class CallbackController {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Resource
    private OpenSyncBizDataMapper openSyncBizDataMapper;
    @Resource
    private OpenSyncBizDataMediumMapper openSyncBizDataMediumMapper;
    private static final String EVENT_CHECK_CREATE_SUITE_URL = "check_create_suite_url";
    private static final String EVENT_CHECK_UPADTE_SUITE_URL = "check_update_suite_url";
    private static final String EVENT_SUITE_TICKET = "suite_ticket";
    private static final String EVENT_TMP_AUTH_CODE = "tmp_auth_code";
    private static final String SYNC_HTTP_PUSH_HIGH = "SYNC_HTTP_PUSH_HIGH";
    private static final String SYNC_HTTP_PUSH_MEDIUM = "SYNC_HTTP_PUSH_MEDIUM";
    @Resource
    private TestService testService;

    @NotNeedLogin
    @PassToken
    @GetMapping(value={"/test"})
    public ServiceResult qianxueProvince() throws Exception {
        this.testService.test();
        return ServiceResult.getSuccessResult((Object)"222");
    }

    @PostMapping(value={"dingCallback"})
    @NotNeedLogin
    @PassToken
    public Object dingCallback(@RequestParam(value="signature") String signature, @RequestParam(value="timestamp") Long timestamp, @RequestParam(value="nonce") String nonce, @RequestBody(required=false) JSONObject body) {
        String params = "signature:" + signature + " timestamp:" + timestamp + " nonce:" + nonce + " body:" + body;
        try {
            this.log.info("begin callback:" + params);
            DingTalkEncryptor dingTalkEncryptor = new DingTalkEncryptor("zqi8CSAabdTLk3jbQvp2KCyWxq8rvsadAT7GbuX3ZS1pjAtqcjxkXs4", "UYboalUGBhyQHHYsofTZujQSGKTjTS7XzIKAg9WOTkD", "suite7qpn3g5gso1ljzi6");
            String encrypt = body.getString("encrypt");
            String plainText = dingTalkEncryptor.getDecryptMsg(signature, timestamp.toString(), nonce, encrypt);
            JSONObject callBackContent = JSON.parseObject((String)plainText);
            this.log.info("\u56de\u8c03\u89e3\u5bc6\u6570\u636e:{}", (Object)plainText);
            String eventType = callBackContent.getString("EventType");
            if (SYNC_HTTP_PUSH_HIGH.equals(eventType)) {
                this.updateBizData(callBackContent);
            } else if (SYNC_HTTP_PUSH_MEDIUM.equals(eventType)) {
                this.updateBizDataMedium(callBackContent);
            }
            return dingTalkEncryptor.getEncryptedMap("success", timestamp, nonce);
        }
        catch (Exception e) {
            this.log.error("process callback fail." + params, (Throwable)e);
            return "fail";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateBizData(JSONObject callBackContent) {
        DynamicDataSource.resetDataSource((String)"dpsDataSource");
        try {
            JSONArray bizDataArray = callBackContent.getJSONArray("bizData");
            ArrayList openSyncBizDataList = Lists.newArrayList();
            bizDataArray.forEach(bizData -> {
                OpenSyncBizData openSyncBizData = this.paramConvert((JSONObject)bizData);
                this.openSyncBizDataMapper.deleteByUkSubscribeCorpBiz(openSyncBizData);
                this.openSyncBizDataMapper.deleteById(openSyncBizData.getId());
                openSyncBizDataList.add(openSyncBizData);
            });
            this.openSyncBizDataMapper.insertBizData((List)openSyncBizDataList);
        }
        catch (Exception e) {
            this.log.error("updateBizData\u66f4\u65b0\u56de\u8c03\u6570\u636e\u5931\u8d25:{}", (Object)JsonUtil.obj2String((Object)callBackContent), (Object)e);
        }
        finally {
            DynamicDataSource.resetDataSource((String)"masterDataSource");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateBizDataMedium(JSONObject callBackContent) {
        DynamicDataSource.resetDataSource((String)"dpsDataSource");
        try {
            JSONArray bizDataArray = callBackContent.getJSONArray("bizData");
            ArrayList openSyncBizDataMediumList = Lists.newArrayList();
            bizDataArray.forEach(bizData -> {
                OpenSyncBizData openSyncBizData = this.paramConvert((JSONObject)bizData);
                OpenSyncBizDataMedium openSyncBizDataMedium = new OpenSyncBizDataMedium();
                BeanUtils.copyProperties((Object)openSyncBizData, (Object)openSyncBizDataMedium);
                this.openSyncBizDataMediumMapper.deleteByUkSubscribeCorpBiz(openSyncBizDataMedium);
                this.openSyncBizDataMediumMapper.deleteById(openSyncBizDataMedium.getId());
                openSyncBizDataMediumList.add(openSyncBizDataMedium);
            });
            this.openSyncBizDataMediumMapper.insertBizData((List)openSyncBizDataMediumList);
        }
        catch (Exception e) {
            this.log.error("updateBizDataMedium\u66f4\u65b0\u56de\u8c03\u6570\u636e\u5931\u8d25:{}", (Object)JsonUtil.obj2String((Object)callBackContent), (Object)e);
        }
        finally {
            DynamicDataSource.resetDataSource((String)"masterDataSource");
        }
    }

    private OpenSyncBizData paramConvert(JSONObject bizData) {
        int bizType = bizData.getIntValue("biz_type");
        String subscribeId = bizData.getString("subscribe_id");
        String bizId = bizData.getString("biz_id");
        Long openCursor = bizData.getLong("open_cursor");
        Long id = bizData.getLong("id");
        Date gmtCreate = bizData.getDate("gmt_create");
        Date gmtModified = bizData.getDate("gmt_modified");
        Integer status = bizData.getInteger("status");
        String innerBizData = bizData.getString("biz_data");
        String corpId = bizData.getString("corp_id");
        OpenSyncBizData openSyncBizData = new OpenSyncBizData();
        openSyncBizData.setId(id);
        openSyncBizData.setBizData(innerBizData);
        openSyncBizData.setBizType(Integer.valueOf(bizType));
        openSyncBizData.setCorpId(corpId);
        openSyncBizData.setGmtCreate(gmtCreate);
        openSyncBizData.setGmtModified(gmtModified);
        openSyncBizData.setOpenCursor(openCursor);
        openSyncBizData.setStatus(status);
        openSyncBizData.setSubscribeId(subscribeId);
        openSyncBizData.setBizId(bizId);
        return openSyncBizData;
    }
}

