/*
 * Decompiled with CFR 0.152.
 */
package com.xfw.work.controller.common;

import com.xfw.common.response.ServiceResult;
import com.xfw.common.util.AssertUtils;
import com.xfw.dingtalk.contacts.model.bo.JsapiAuthBO;
import com.xfw.dingtalk.contacts.service.foreign.DingTalkTicketService;
import com.xfw.work.model.common.SessionUser;
import com.xfw.work.util.RedisUtil;
import com.xfw.work.util.SessionManager;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/ding"})
public class DingController {
    private static final Logger log = LoggerFactory.getLogger(DingController.class);
    @Autowired
    private DingTalkTicketService dingTalkTicketService;
    @Autowired
    private RedisUtil redisUtil;

    @GetMapping(value={"/getJsapiAuth"})
    public ServiceResult getJsapiAuth(String url) {
        SessionUser sessionUser = SessionManager.getSessionUser();
        AssertUtils.notBlank((String)url, (String)"please input auth url");
        JsapiAuthBO authBO = this.dingTalkTicketService.jsapiAuth(sessionUser.getCompanyId(), sessionUser.getCorpId(), url);
        return ServiceResult.success((Object)authBO);
    }

    @GetMapping(value={"/authorizeApiSuccess"})
    public ServiceResult authorizeApiSuccess() {
        SessionUser sessionUser = SessionManager.getSessionUser();
        String key = "auth_api:" + sessionUser.getCompanyId();
        this.redisUtil.set(key, "1");
        return ServiceResult.success((Object)true);
    }

    @GetMapping(value={"/isNeedAuthorizeApi"})
    public ServiceResult isNeedAuthorizeApi() {
        SessionUser sessionUser = SessionManager.getSessionUser();
        String key = "auth_api:" + sessionUser.getCompanyId();
        Object value = this.redisUtil.get(key);
        return ServiceResult.success((Object)(Objects.isNull(value) ? 1 : 0));
    }
}

