/*
 * Decompiled with CFR 0.152.
 */
package com.xfw.work.controller.biz;

import com.xfw.work.model.common.ServiceResult;
import com.xfw.work.model.common.SessionUser;
import com.xfw.work.model.param.GiftPackGetParam;
import com.xfw.work.service.impl.GiftPackService;
import com.xfw.work.util.SessionManager;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/choose/gift/pack"})
public class ChooseGiftPackController {
    @Resource
    private GiftPackService giftPackService;

    @PostMapping(value={"/get"})
    public ServiceResult<Boolean> get(@RequestBody GiftPackGetParam param) {
        return ServiceResult.getSuccessResult((Object)this.giftPackService.get(param));
    }

    @GetMapping(value={"/canGetGift"})
    public ServiceResult<Boolean> canGetGift() {
        SessionUser sessionUser = SessionManager.getSessionUser();
        return ServiceResult.getSuccessResult((Object)this.giftPackService.isInWhiteDept(sessionUser.getCompanyId(), sessionUser.getUserId()));
    }

    @GetMapping(value={"/hasGiftInfo"})
    public ServiceResult<List<Integer>> hasGiftInfo() {
        return ServiceResult.getSuccessResult((Object)this.giftPackService.hasGiftInfo());
    }
}

