/*
 * Decompiled with CFR 0.152.
 */
package com.xfw.work.config.interceptor;

import com.xfw.common.exception.BusinessException;
import com.xfw.common.util.StringUtils;
import com.xfw.web.context.SpringContextHolder;
import com.xfw.work.config.annotation.Filter;
import com.xfw.work.config.annotation.PassToken;
import com.xfw.work.config.annotation.Repeat;
import com.xfw.work.model.common.SessionUser;
import com.xfw.work.model.enums.ActiveProfileEnum;
import com.xfw.work.util.ApplicationContextProvider;
import com.xfw.work.util.RedisUtil;
import com.xfw.work.util.SessionManager;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

@Component
public class UrlInterceptor
extends HandlerInterceptorAdapter {
    private static final Logger logger = LoggerFactory.getLogger(UrlInterceptor.class);
    private final RedisUtil redisService = (RedisUtil)SpringContextHolder.getBean(RedisUtil.class);
    private static final String REDIS_KEY = "SQ_SWITCH";
    public static final Set<String> FILTER_REFERER = new /* Unavailable Anonymous Inner Class!! */;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        request.setAttribute("startTime", (Object)System.currentTimeMillis());
        String referrer = request.getHeader("referer");
        this.printRequestInfo(request, handler, referrer);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(request.getScheme()).append("://").append(request.getServerName());
        if (referrer == null || "".equals(referrer) || referrer.lastIndexOf(String.valueOf(stringBuffer)) == 0) {
            return this.validation(request, response, handler);
        }
        for (String referer : FILTER_REFERER) {
            if (!referrer.contains(referer)) continue;
            return this.validation(request, response, handler);
        }
        logger.warn("crsf\u653b\u51fb-------------referrer={}", (Object)referrer);
        return false;
    }

    private void printRequestInfo(HttpServletRequest request, Object handler, String referrer) throws IOException {
        StringBuilder sb = new StringBuilder(1000);
        sb.append(" ==> [").append(handler).append("],\u8bf7\u6c42\u5f00\u59cb++++++\u4fe1\u606f\n");
        sb.append("URL:").append(request.getRequestURL()).append("\n");
        sb.append("referrer:").append(referrer).append("\n");
        sb.append("Method:").append(request.getMethod()).append("\n");
        if (logger.isDebugEnabled()) {
            sb.append("handle:").append(handler).append("\n");
            sb.append("Protocol:").append(request.getProtocol()).append("\n");
            sb.append("URI:").append(request.getRequestURI()).append("\n");
            sb.append("-------\u8bf7\u6c42\u5934\u2228\u2228\u2228\u2228\u2228 ").append("\n");
            Enumeration enu = request.getHeaderNames();
            while (enu.hasMoreElements()) {
                String name = (String)enu.nextElement();
                sb.append(name).append(":").append(request.getHeader(name)).append("\n");
            }
            sb.append("-------\u8bf7\u6c42\u5934\u2227\u2227\u2227\u2227\u2227>\n");
        }
        sb.append("-------\u8bf7\u6c42\u53c2\u6570\u2228\u2228\u2228\u2228\u2228\n");
        Enumeration parameters = request.getParameterNames();
        while (parameters.hasMoreElements()) {
            String paramName = parameters.nextElement().toString();
            sb.append(paramName);
            sb.append("=");
            sb.append(request.getParameter(paramName));
            sb.append("\n");
        }
        sb.append("-------\u8bf7\u6c42\u53c2\u6570\u2227\u2227\u2227\u2227\u2227\n");
        SessionUser user = SessionManager.getSessionUser();
        if (null != user) {
            sb.append("\u8bf7\u6c42\u7528\u6237\u4fe1\u606f:companyId=").append(user.getCompanyId()).append(",userId=").append(user.getUserId());
        }
        logger.info(sb.toString());
    }

    public void postHandle(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Object handler, ModelAndView modelAndView) throws Exception {
        long startTime = (Long)httpServletRequest.getAttribute("startTime");
        long endTime = System.currentTimeMillis();
        logger.info(" <== [{}],\u8bf7\u6c42\u7ed3\u675f++++++\u8017\u65f6: {}ms", handler, (Object)(endTime - startTime));
    }

    public void afterCompletion(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Object o, Exception e) throws Exception {
    }

    private boolean validation(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        if (handler instanceof HandlerMethod) {
            SessionUser user;
            PassToken notCheck;
            HandlerMethod handlerMethod = (HandlerMethod)handler;
            Method method = handlerMethod.getMethod();
            Filter filter = method.getAnnotation(Filter.class);
            if (filter != null) {
                String token = request.getHeader("token");
                if (StringUtils.isBlank((CharSequence)token)) {
                    token = request.getParameter("token");
                }
                if (StringUtils.isBlank((CharSequence)token)) {
                    throw new BusinessException("token\u4e0d\u80fd\u4e3a\u7a7a");
                }
                request.setAttribute("objectMD5", (Object)token);
            }
            if ((notCheck = method.getAnnotation(PassToken.class)) == null && Objects.isNull(user = SessionManager.getSessionUser())) {
                return true;
            }
            Repeat repeat = method.getAnnotation(Repeat.class);
            if (ActiveProfileEnum.pro.name().equals(ApplicationContextProvider.getActiveProfile()) && repeat != null) {
                String repeatStr = request.getHeader("repeat");
                String token = request.getHeader("token");
                if (StringUtils.isEmpty((CharSequence)token)) {
                    throw new BusinessException("\u8bf7\u9000\u51fa\u9489\u9489\u91cd\u8bd5\uff01");
                }
                if (StringUtils.isBlank((CharSequence)repeatStr)) {
                    repeatStr = request.getParameter("repeat");
                }
                if (StringUtils.isBlank((CharSequence)repeatStr)) {
                    throw new BusinessException("repeat\u4e0d\u80fd\u4e3a\u7a7a");
                }
                SessionUser user2 = SessionManager.getSessionUser();
                if (Objects.isNull(user2)) {
                    return true;
                }
                String s = (String)this.redisService.get("repeat:" + user2.getUserId() + token);
                String repeat1 = UUID.randomUUID().toString();
                if (StringUtils.isNotEmpty((CharSequence)s) && !repeatStr.equals(s)) {
                    throw new BusinessException("\u8bf7\u4e0d\u8981\u91cd\u590d\u63d0\u4ea4");
                }
                this.redisService.set("repeat:" + user2.getUserId() + token, repeat1, 7200L);
                response.setHeader("repeat", repeat1);
            }
            return true;
        }
        return super.preHandle(request, response, handler);
    }
}

