/*
 * Decompiled with CFR 0.152.
 */
package com.xfw.work.config.interceptor;

import com.auth0.jwt.JWT;
import com.auth0.jwt.JWTVerifier;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.exceptions.JWTDecodeException;
import com.auth0.jwt.exceptions.JWTVerificationException;
import com.xfw.common.util.StringUtils;
import com.xfw.work.config.annotation.NotNeedLoginToken;
import com.xfw.work.config.annotation.PassToken;
import com.xfw.work.model.bo.UserBO;
import com.xfw.work.model.common.TokenException;
import com.xfw.work.service.UserService;
import com.xfw.work.util.RedisUtil;
import com.xfw.work.util.SessionManager;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

@Component
public class AuthenticationInterceptor
implements HandlerInterceptor {
    private static final Logger log = LoggerFactory.getLogger(AuthenticationInterceptor.class);
    @Resource
    private UserService userService;
    @Autowired
    private RedisUtil redisUtil;

    public static String getToken(UserBO user) {
        String token = "";
        token = JWT.create().withAudience(new String[]{String.valueOf(user.getUserId()), user.getCompanyId() + "", System.currentTimeMillis() + ""}).sign(Algorithm.HMAC256((String)user.getUsername()));
        log.info("name:{} token is :{}", (Object)user.getUsername(), (Object)token);
        return token;
    }

    public boolean preHandle(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Object object) throws Exception {
        PassToken passToken;
        String token = httpServletRequest.getHeader("token");
        if (StringUtils.isEmpty((CharSequence)token)) {
            token = httpServletRequest.getParameter("token");
        }
        if (!(object instanceof HandlerMethod)) {
            return true;
        }
        HandlerMethod handlerMethod = (HandlerMethod)object;
        Method method = handlerMethod.getMethod();
        if (method.isAnnotationPresent(PassToken.class) && (passToken = method.getAnnotation(PassToken.class)).required()) {
            return true;
        }
        if (!method.isAnnotationPresent(NotNeedLoginToken.class)) {
            String companyId;
            String userId;
            NotNeedLoginToken userLoginToken = method.getAnnotation(NotNeedLoginToken.class);
            if (token == null) {
                throw new RuntimeException("\u65e0token\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55");
            }
            try {
                List audience = JWT.decode((String)token).getAudience();
                userId = (String)audience.get(0);
                companyId = (String)audience.get(1);
            }
            catch (JWTDecodeException j) {
                throw new RuntimeException("token\u65e0\u6548");
            }
            Object tokenObj = this.redisUtil.get("work:login:user:" + userId);
            if (Objects.isNull(tokenObj)) {
                throw new TokenException("\u65e0\u6548token\uff0c\u8bf7\u91cd\u65b0\u767b\u9646");
            }
            String loginToken = (String)tokenObj;
            if (!loginToken.equals(token)) {
                throw new TokenException("\u5f53\u524d\u8d26\u53f7\u5df2\u5728\u5176\u5b83\u8bbe\u5907\u767b\u5f55\uff0c\u8bf7\u786e\u8ba4\uff01");
            }
            UserBO user = this.userService.getUserById(Long.valueOf(Long.parseLong(companyId)), Long.valueOf(Long.parseLong(userId)));
            if (user == null) {
                throw new RuntimeException("\u7528\u6237\u4e0d\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55");
            }
            JWTVerifier jwtVerifier = JWT.require((Algorithm)Algorithm.HMAC256((String)user.getUsername())).build();
            try {
                jwtVerifier.verify(token);
                SessionManager.generateSessionUser((HttpServletRequest)httpServletRequest, (UserBO)user);
            }
            catch (JWTVerificationException e) {
                throw new RuntimeException("token\u9a8c\u8bc1\u672a\u901a\u8fc7");
            }
            return true;
        }
        return true;
    }

    public void postHandle(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Object o, ModelAndView modelAndView) throws Exception {
    }

    public void afterCompletion(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Object o, Exception e) throws Exception {
    }
}

