/*
 * Decompiled with CFR 0.152.
 */
package com.xfw.corpCode.service.impl;

import com.alibaba.fastjson.JSON;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.xfw.common.exception.BusinessException;
import com.xfw.common.structure.Pair;
import com.xfw.common.util.CollectionUtils;
import com.xfw.common.util.IDGenerator;
import com.xfw.common.util.StringUtils;
import com.xfw.corpCode.helper.ProbabilityRandomPicker;
import com.xfw.corpCode.helper.RedPacketUtils;
import com.xfw.corpCode.helper.UserMoneyRecordTracker;
import com.xfw.corpCode.listener.SubsidyNumEvent;
import com.xfw.corpCode.model.entity.MoneySubsidy;
import com.xfw.corpCode.model.entity.MoneySubsidyRecord;
import com.xfw.corpCode.model.entity.RefundRecord;
import com.xfw.corpCode.model.enums.SubsidyNumTypeEnum;
import com.xfw.corpCode.model.enums.SubsidyNumUpdateEnum;
import com.xfw.corpCode.model.enums.SubsidyTypeEnum;
import com.xfw.corpCode.model.param.QueryPayParam;
import com.xfw.corpCode.model.param.subsidy.SubsidyParam;
import com.xfw.corpCode.model.vo.CanGetMoneySubsidyVO;
import com.xfw.corpCode.model.vo.QueryRecord;
import com.xfw.corpCode.persistence.mapper.MoneySubsidyMapper;
import com.xfw.corpCode.persistence.mapper.MoneySubsidyRecordMapper;
import com.xfw.corpCode.persistence.mapper.RefundRecordMapper;
import com.xfw.corpCode.service.SubsidyService;
import com.xfw.mybatis.page.PageResult;
import com.xfw.mybatis.page.PageVO;
import com.xfw.work.util.RedisUtil;
import com.xfw.work.util.event.local.LocalEventPublisher;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.assertj.core.util.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import tk.mybatis.mapper.entity.Example;

@Service
public class SubsidyServiceImpl
implements SubsidyService {
    private static final Logger log = LoggerFactory.getLogger(SubsidyServiceImpl.class);
    @Resource
    private RedisUtil redisUtil;
    @Resource
    private RedisTemplate<String, BigDecimal> redisTemplate;
    @Resource
    private MoneySubsidyMapper moneySubsidyMapper;
    @Resource
    private MoneySubsidyRecordMapper moneySubsidyRecordMapper;
    @Resource
    private RefundRecordMapper refundRecordMapper;
    @Resource
    private UserMoneyRecordTracker userMoneyRecordTracker;

    public void addSubsidy(SubsidyParam input) {
        this.checkParams(input);
        List bigDecimals = RedPacketUtils.genRanddomList((BigDecimal)input.getTotalMoney(), (Integer)input.getTotalNum(), (BigDecimal)input.getMinMoney(), (BigDecimal)input.getMaxMoney());
        this.checkSubsidy(input, bigDecimals);
        Long id = IDGenerator.getId();
        MoneySubsidy moneySubsidy = new MoneySubsidy();
        moneySubsidy.setId(id);
        moneySubsidy.setCreateUserId(Long.valueOf(11111L));
        moneySubsidy.setTotalMoney(input.getTotalMoney());
        moneySubsidy.setTotalNum(input.getTotalNum());
        moneySubsidy.setMaxMoney(input.getMaxMoney());
        moneySubsidy.setMinMoney(input.getMinMoney());
        moneySubsidy.setSurplusQueryNum(input.getTotalNum());
        moneySubsidy.setSurplusNum(input.getTotalNum());
        moneySubsidy.setType(input.getType());
        moneySubsidy.setLevelMoney(input.getLevelMoney());
        moneySubsidy.setGmtCreate(new Date());
        this.moneySubsidyMapper.insertSelective((Object)moneySubsidy);
        this.redisTemplate.opsForList().leftPushAll((Object)("money:subsidy:" + id), (Collection)bigDecimals);
        this.updateCanGetMoneySubsidy();
    }

    public PageResult<MoneySubsidy> getSubsidyList(PageVO page) {
        PageHelper.startPage((int)page.getPageNo(), (int)page.getPageSize());
        Example example = new Example(MoneySubsidy.class);
        example.createCriteria().andEqualTo("deleteFlag", (Object)0);
        List moneySubsidies = this.moneySubsidyMapper.selectByExample((Object)example);
        if (CollectionUtils.isEmpty((Collection)moneySubsidies)) {
            return new PageResult();
        }
        return new PageResult(moneySubsidies, new PageInfo(moneySubsidies));
    }

    private void checkSubsidy(SubsidyParam input, List<BigDecimal> bigDecimals) {
        if (CollectionUtils.isEmpty(bigDecimals) || bigDecimals.size() != input.getTotalNum().intValue()) {
            log.error("\u8865\u8d34\u751f\u6210\u6709\u8bef:{},data:{}", (Object)JSON.toJSONString((Object)input), (Object)JSON.toJSONString(bigDecimals));
            throw new BusinessException("\u8865\u8d34\u751f\u6210\u6709\u8bef");
        }
        if (bigDecimals.stream().anyMatch(bigDecimal -> bigDecimal.compareTo(input.getMinMoney()) < 0 || bigDecimal.compareTo(input.getMaxMoney()) > 0)) {
            log.error("\u8865\u8d34\u751f\u6210\u6709\u8bef:{},data:{}", (Object)JSON.toJSONString((Object)input), (Object)JSON.toJSONString(bigDecimals));
            throw new BusinessException("\u8865\u8d34\u751f\u6210\u6709\u8bef");
        }
        if (bigDecimals.stream().reduce(BigDecimal.ZERO, BigDecimal::add).compareTo(input.getTotalMoney()) != 0) {
            log.error("\u8865\u8d34\u751f\u6210\u6709\u8bef:{},data:{}", (Object)JSON.toJSONString((Object)input), (Object)JSON.toJSONString(bigDecimals));
            throw new BusinessException();
        }
    }

    private void checkParams(SubsidyParam input) {
        if (input.getTotalMoney().compareTo(input.getMaxMoney().multiply(new BigDecimal(input.getTotalNum()))) > 0) {
            throw new RuntimeException("\u8bf7\u6821\u9a8c\u8865\u8d34\u8bbe\u7f6e\u7684\u5408\u7406\u6027");
        }
        if (input.getMinMoney().compareTo(input.getMaxMoney()) > 0) {
            throw new RuntimeException("\u8d77\u59cb\u533a\u95f4\u4e0d\u80fd\u5927\u4e8e\u7ed3\u675f\u533a\u95f4");
        }
    }

    public void updateCanGetMoneySubsidy() {
        Example example = new Example(MoneySubsidy.class);
        example.createCriteria().andEqualTo("deleteFlag", (Object)0).andGreaterThan("surplusQueryNum", (Object)0).andGreaterThan("surplusNum", (Object)0);
        List moneySubsidies = this.moneySubsidyMapper.selectByExample((Object)example);
        if (CollectionUtils.isEmpty((Collection)moneySubsidies)) {
            this.redisUtil.set("can:get:money:subsidy", JSON.toJSONString((Object)Lists.newArrayList()));
            return;
        }
        List data = moneySubsidies.stream().map(arg_0 -> this.parseCanGetMoneySubsidy(arg_0)).collect(Collectors.toList());
        this.redisUtil.set("can:get:money:subsidy", JSON.toJSONString(data));
    }

    public void deleteSubsidy(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            throw new BusinessException("id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        log.info("\u5220\u9664\u7acb\u51cf\u91d1\u989did:{}", (Object)id);
        MoneySubsidy moneySubsidy = new MoneySubsidy();
        moneySubsidy.setId(Long.valueOf(id));
        moneySubsidy.setDeleteFlag(Integer.valueOf(1));
        this.moneySubsidyMapper.updateByPrimaryKeySelective((Object)moneySubsidy);
        this.updateCanGetMoneySubsidy();
    }

    public CanGetMoneySubsidyVO getMoneySubsidyByAmount(BigDecimal amount) {
        Object obj = this.redisUtil.get("can:get:money:subsidy");
        if (Objects.isNull(obj)) {
            return null;
        }
        List data = JSON.parseArray((String)obj.toString(), CanGetMoneySubsidyVO.class);
        if (CollectionUtils.isEmpty((Collection)data)) {
            return null;
        }
        List fitData = data.stream().filter(s -> s.getLevelMoney().compareTo(amount) <= 0).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(fitData)) {
            return null;
        }
        if (fitData.size() == 1) {
            return (CanGetMoneySubsidyVO)fitData.get(0);
        }
        fitData.sort(Comparator.comparing(CanGetMoneySubsidyVO::getLevelMoney).reversed());
        if (((CanGetMoneySubsidyVO)fitData.get(0)).getType().equals(SubsidyTypeEnum.NORMAL.getType())) {
            return (CanGetMoneySubsidyVO)fitData.get(0);
        }
        if (((CanGetMoneySubsidyVO)fitData.get(0)).getType().equals(SubsidyTypeEnum.BIG.getType())) {
            if (fitData.size() > 3) {
                return this.randomGet(fitData.subList(0, 3));
            }
            return this.randomGet(fitData);
        }
        return this.randomGet(fitData);
    }

    private CanGetMoneySubsidyVO randomGet(List<CanGetMoneySubsidyVO> fitData) {
        Collections.shuffle(fitData);
        int sum = fitData.stream().mapToInt(CanGetMoneySubsidyVO::getSurplusNum).sum();
        ArrayList items = Lists.newArrayList();
        fitData.forEach(s -> {
            double weight = (double)s.getSurplusNum().intValue() * 1.0 / (double)sum;
            items.add(Pair.create((Object)s, (Object)weight));
        });
        ProbabilityRandomPicker probabilityRandomPicker = new ProbabilityRandomPicker((List)items);
        return (CanGetMoneySubsidyVO)probabilityRandomPicker.getRandomItem();
    }

    public static void main(String[] args) {
        ArrayList fitData = Lists.newArrayList();
        CanGetMoneySubsidyVO canGetMoneySubsidyVO = new CanGetMoneySubsidyVO();
        canGetMoneySubsidyVO.setId(Long.valueOf(1L));
        canGetMoneySubsidyVO.setSurplusNum(Integer.valueOf(60));
        CanGetMoneySubsidyVO canGetMoneySubsidyVO2 = new CanGetMoneySubsidyVO();
        canGetMoneySubsidyVO2.setId(Long.valueOf(2L));
        canGetMoneySubsidyVO2.setSurplusNum(Integer.valueOf(30));
        CanGetMoneySubsidyVO canGetMoneySubsidyVO3 = new CanGetMoneySubsidyVO();
        canGetMoneySubsidyVO3.setId(Long.valueOf(2L));
        canGetMoneySubsidyVO3.setSurplusNum(Integer.valueOf(10));
        fitData.add(canGetMoneySubsidyVO);
        fitData.add(canGetMoneySubsidyVO3);
        fitData.add(canGetMoneySubsidyVO2);
        int sum = fitData.stream().mapToInt(CanGetMoneySubsidyVO::getSurplusNum).sum();
        ArrayList items = Lists.newArrayList();
        fitData.forEach(s -> {
            double weight = (double)s.getSurplusNum().intValue() * 1.0 / (double)sum;
            items.add(Pair.create((Object)s, (Object)weight));
        });
        fitData.sort(Comparator.comparing(CanGetMoneySubsidyVO::getSurplusNum).reversed());
        for (int i = 0; i < 50; ++i) {
            ProbabilityRandomPicker probabilityRandomPicker = new ProbabilityRandomPicker((List)items);
            CanGetMoneySubsidyVO randomItem = (CanGetMoneySubsidyVO)probabilityRandomPicker.getRandomItem();
            System.out.println(i + "------" + JSON.toJSONString((Object)randomItem));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BigDecimal getMoneySubsidyByOrder(String tradeNo, String employeeId, BigDecimal amount) {
        CanGetMoneySubsidyVO moneySubsidy;
        BigDecimal subsidyMoney;
        block6: {
            subsidyMoney = new BigDecimal(0);
            moneySubsidy = this.getMoneySubsidyByAmount(amount);
            if (Objects.isNull(moneySubsidy)) {
                return subsidyMoney;
            }
            while (!this.redisUtil.setIfAbsent("money:subsidy:lock:" + moneySubsidy.getId(), "running", 20L).booleanValue()) {
            }
            try {
                BigDecimal value = (BigDecimal)this.redisTemplate.opsForList().leftPop((Object)("money:subsidy:" + moneySubsidy.getId()));
                if (!Objects.nonNull(value)) break block6;
                subsidyMoney = value;
                this.addRedisQueryRecord(tradeNo, subsidyMoney, moneySubsidy.getId());
                this.userMoneyRecordTracker.addRecord(employeeId, subsidyMoney, moneySubsidy.getId());
                this.updateSubsidyNum(moneySubsidy.getId(), SubsidyNumTypeEnum.QUERY_NUM.getType(), SubsidyNumUpdateEnum.DEDUCT.getType());
            }
            catch (Exception e) {
                try {
                    log.error("\u6263\u51cf\u51fa\u9519:\u8865\u8d34id:{},\u9519\u8bef:{}", (Object)moneySubsidy.getId(), (Object)e.getMessage());
                }
                catch (Throwable throwable) {
                    this.redisUtil.del(new String[]{"money:subsidy:lock:" + moneySubsidy.getId()});
                }
                this.redisUtil.del(new String[]{"money:subsidy:lock:" + moneySubsidy.getId()});
            }
        }
        this.redisUtil.del(new String[]{"money:subsidy:lock:" + moneySubsidy.getId()});
        return subsidyMoney;
    }

    public MoneySubsidyRecord isExistPayRecord(QueryPayParam input) {
        Example example = new Example(MoneySubsidyRecord.class);
        example.createCriteria().andEqualTo("tradeNo", (Object)input.getTrade_no()).andEqualTo("standardId", (Object)input.getStandard_id()).andEqualTo("applyAmount", (Object)input.getApply_amount());
        List moneySubsidyRecords = this.moneySubsidyRecordMapper.selectByExample((Object)example);
        if (CollectionUtils.isNotEmpty((Collection)moneySubsidyRecords)) {
            return (MoneySubsidyRecord)moneySubsidyRecords.get(0);
        }
        return null;
    }

    public MoneySubsidyRecord getPayRecordByTradeNo(String tradeNo) {
        Example example = new Example(MoneySubsidyRecord.class);
        example.createCriteria().andEqualTo("tradeNo", (Object)tradeNo);
        List moneySubsidyRecords = this.moneySubsidyRecordMapper.selectByExample((Object)example);
        if (CollectionUtils.isNotEmpty((Collection)moneySubsidyRecords)) {
            return (MoneySubsidyRecord)moneySubsidyRecords.get(0);
        }
        return null;
    }

    public void updatePayRecordStatus(String tradeNo, Integer status) {
        Example example = new Example(MoneySubsidyRecord.class);
        example.createCriteria().andEqualTo("tradeNo", (Object)tradeNo);
        MoneySubsidyRecord moneySubsidyRecord = new MoneySubsidyRecord();
        moneySubsidyRecord.setStatus(status);
        this.moneySubsidyRecordMapper.updateByExampleSelective((Object)moneySubsidyRecord, (Object)example);
    }

    public Boolean isExistRefundRecord(String tradeNo, String refundNo) {
        Example example = new Example(RefundRecord.class);
        example.createCriteria().andEqualTo("refundNo", (Object)refundNo).andEqualTo("tradeNo", (Object)tradeNo);
        RefundRecord refundRecord = (RefundRecord)this.refundRecordMapper.selectOneByExample((Object)example);
        return Objects.nonNull(refundRecord);
    }

    public List<RefundRecord> getRefundRecordList(String tradeNo) {
        Example example = new Example(RefundRecord.class);
        example.createCriteria().andEqualTo("tradeNo", (Object)tradeNo);
        List refundRecords = this.refundRecordMapper.selectByExample((Object)example);
        if (CollectionUtils.isEmpty((Collection)refundRecords)) {
            return Lists.newArrayList();
        }
        return refundRecords;
    }

    public void updateSubsidyNum(Long subsidyId, Integer type, Integer updateType) {
        SubsidyNumEvent subsidyNumEvent = new SubsidyNumEvent();
        subsidyNumEvent.setSubsidyId(subsidyId);
        subsidyNumEvent.setUpdateType(updateType);
        subsidyNumEvent.setType(type);
        LocalEventPublisher.publish((Object)subsidyNumEvent);
    }

    public void addRedisQueryRecord(String tradeNo, BigDecimal subsidyMoney, Long subsidyId) {
        QueryRecord queryRecord = new QueryRecord();
        queryRecord.setTradeNo(tradeNo);
        queryRecord.setSubsidyMoney(subsidyMoney);
        queryRecord.setSubsidyId(subsidyId);
        queryRecord.setQueryDate(new Date());
        this.redisUtil.set("consult:subsidy:" + tradeNo, JSON.toJSONString((Object)queryRecord));
    }

    private CanGetMoneySubsidyVO parseCanGetMoneySubsidy(MoneySubsidy moneySubsidy) {
        CanGetMoneySubsidyVO canGetMoneySubsidyVO = new CanGetMoneySubsidyVO();
        canGetMoneySubsidyVO.setId(moneySubsidy.getId());
        canGetMoneySubsidyVO.setMaxMoney(moneySubsidy.getMaxMoney());
        canGetMoneySubsidyVO.setLevelMoney(moneySubsidy.getLevelMoney());
        canGetMoneySubsidyVO.setType(moneySubsidy.getType());
        canGetMoneySubsidyVO.setSurplusNum(moneySubsidy.getSurplusNum());
        return canGetMoneySubsidyVO;
    }
}

