/*
 * Decompiled with CFR 0.152.
 */
package com.xfw.corpCode.service.impl;

import com.alibaba.fastjson.JSON;
import com.alipay.api.domain.StandardIdInfo;
import com.alipay.api.response.AlipayEbppInvoiceInstitutionCreateResponse;
import com.alipay.api.response.AlipayUserInfoShareResponse;
import com.xfw.common.exception.BusinessException;
import com.xfw.common.util.CollectionUtils;
import com.xfw.common.util.IDGenerator;
import com.xfw.common.util.StringUtils;
import com.xfw.corpCode.listener.CreateEmployeeEvent;
import com.xfw.corpCode.model.entity.InstitutionInfo;
import com.xfw.corpCode.model.entity.StandardInfo;
import com.xfw.corpCode.model.param.CreateInstitutionParam;
import com.xfw.corpCode.model.param.DeleteInstitutionParam;
import com.xfw.corpCode.model.vo.AlipayLoginUserVO;
import com.xfw.corpCode.persistence.mapper.InstitutionInfoMapper;
import com.xfw.corpCode.persistence.mapper.StandardInfoMapper;
import com.xfw.corpCode.service.CorpCodeBizService;
import com.xfw.corpCode.service.CorpCodeService;
import com.xfw.work.model.common.SessionUser;
import com.xfw.work.util.SessionManager;
import com.xfw.work.util.event.local.LocalEventPublisher;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.assertj.core.util.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import tk.mybatis.mapper.entity.Example;

@Service
public class CorpCodeBizServiceImpl
implements CorpCodeBizService {
    private static final Logger log = LoggerFactory.getLogger(CorpCodeBizServiceImpl.class);
    @Resource
    private CorpCodeService corpCodeService;
    @Resource
    private InstitutionInfoMapper institutionInfoMapper;
    @Resource
    private StandardInfoMapper standardInfoMapper;
    @Resource
    private RedisTemplate<String, String> redisTemplate;

    public void addInstitution(CreateInstitutionParam input) {
        if (!input.getConsult_mode().equals("1")) {
            throw new BusinessException("\u6a21\u5f0f\u4e0d\u7b26\u5408");
        }
        this.checkName(input.getInstitution_name());
        input.setOuter_source_id(IDGenerator.getId().toString());
        input.getStandard_info_list().forEach(standardInfoList -> standardInfoList.setOuter_source_id(IDGenerator.getId().toString()));
        AlipayEbppInvoiceInstitutionCreateResponse institutionRes = this.corpCodeService.createInstitution(input);
        InstitutionInfo institutionInfo = new InstitutionInfo();
        institutionInfo.setId(Long.valueOf(input.getOuter_source_id()));
        institutionInfo.setInstitutionId(institutionRes.getInstitutionId());
        institutionInfo.setInstitutionName(input.getInstitution_name());
        institutionInfo.setSceneType(input.getScene_type());
        institutionInfo.setExpenseType(input.getExpense_type());
        institutionInfo.setEffectiveStartDate(input.getEffective_start_date());
        institutionInfo.setEffectiveEndDate(input.getEffective_end_date());
        institutionInfo.setAccountId(input.getAccount_id());
        institutionInfo.setAgreementNo(input.getAgreement_no());
        institutionInfo.setEnterpriseId(input.getEnterprise_id());
        institutionInfo.setInstitutionDesc(input.getInstitution_desc());
        institutionInfo.setAdapterType(input.getAdapter_type());
        institutionInfo.setConsultMode(input.getConsult_mode());
        institutionInfo.setOwnerType(input.getOwner_type());
        institutionInfo.setOwnerIdList(JSON.toJSONString((Object)input.getOwner_id_list()));
        this.institutionInfoMapper.insertSelective((Object)institutionInfo);
        input.getStandard_info_list().forEach(info -> {
            List stList = institutionRes.getStandardIdInfoList().stream().filter(s -> s.getOuterSourceId().equals(info.getOuter_source_id())).collect(Collectors.toList());
            StandardInfo standardInfo = new StandardInfo();
            standardInfo.setId(Long.valueOf(info.getOuter_source_id()));
            standardInfo.setStandardId(((StandardIdInfo)stList.get(0)).getStandardId());
            standardInfo.setInstitutionId(institutionInfo.getInstitutionId());
            standardInfo.setStandardName(info.getStandard_name());
            standardInfo.setExpenseTypeSubCategory(info.getExpense_type_sub_category());
            standardInfo.setOpenRuleId(info.getOpen_rule_id());
            standardInfo.setPaymentPolicy(info.getPayment_policy());
            standardInfo.setConsumeMode(info.getConsume_mode());
            standardInfo.setStandardDesc(info.getStandard_desc());
            this.standardInfoMapper.insertSelective((Object)standardInfo);
        });
        this.updateStandardRedis();
    }

    public void deleteInstitution(DeleteInstitutionParam input) {
        this.corpCodeService.deleteInstitution(input);
    }

    public void updateStandardRedis() {
        Example example = new Example(StandardInfo.class);
        example.createCriteria().andEqualTo("deleteFlag", (Object)0);
        List standardInfos = this.standardInfoMapper.selectByExample((Object)example);
        if (Objects.isNull(standardInfos)) {
            this.redisTemplate.opsForList().leftPushAll((Object)"standard:list:", (Collection)Lists.newArrayList());
            return;
        }
        List ids = standardInfos.stream().map(StandardInfo::getStandardId).collect(Collectors.toList());
        this.redisTemplate.opsForList().leftPushAll((Object)"standard:list:", ids);
    }

    public Boolean checkIsExistStandard(String standardId) {
        List range = this.redisTemplate.opsForList().range((Object)"standard:list:", 0L, -1L);
        if (CollectionUtils.isEmpty((Collection)range)) {
            return false;
        }
        if (range.contains(standardId)) {
            return true;
        }
        return false;
    }

    public AlipayLoginUserVO login(String code, String userId, String userName) {
        SessionUser sessionUser = SessionManager.getSessionUser();
        if (Objects.isNull(sessionUser)) {
            throw new BusinessException("\u7528\u6237\u672a\u767b\u5f55");
        }
        AlipayUserInfoShareResponse user = this.corpCodeService.login(code);
        log.info("\u652f\u4ed8\u5b9d\u767b\u9646\u7528\u6237user:{}", (Object)JSON.toJSONString((Object)user));
        String zfb_userId = user.getUserId();
        String zfb_userName = user.getUserName();
        String zfb_avatar = user.getAvatar();
        AlipayLoginUserVO alipayLoginUserVO = new AlipayLoginUserVO();
        alipayLoginUserVO.setUserId(zfb_userId);
        alipayLoginUserVO.setUserName(zfb_userName);
        alipayLoginUserVO.setAvatar(zfb_avatar);
        CreateEmployeeEvent createEmployeeEvent = new CreateEmployeeEvent();
        createEmployeeEvent.setEmployeeName(StringUtils.isNotBlank((CharSequence)zfb_userName) ? zfb_userName : sessionUser.getUsername());
        createEmployeeEvent.setAvatar(zfb_avatar);
        createEmployeeEvent.setIdentity(zfb_userId);
        createEmployeeEvent.setDingUserId(sessionUser.getDingUserId());
        LocalEventPublisher.publish((Object)createEmployeeEvent);
        return alipayLoginUserVO;
    }

    private void checkName(String name) {
        Example example = new Example(InstitutionInfo.class);
        example.createCriteria().andEqualTo("institutionName", (Object)name);
        int i = this.institutionInfoMapper.selectCountByExample((Object)example);
        if (i > 0) {
            throw new BusinessException("\u5236\u5ea6\u540d\u79f0\u5df2\u5b58\u5728");
        }
    }
}

