/*
 * Decompiled with CFR 0.152.
 */
package com.xfw.corpCode.listener;

import com.alibaba.fastjson.JSON;
import com.xfw.corpCode.listener.SubsidyNumEvent;
import com.xfw.corpCode.model.entity.MoneySubsidy;
import com.xfw.corpCode.model.enums.SubsidyNumTypeEnum;
import com.xfw.corpCode.model.enums.SubsidyNumUpdateEnum;
import com.xfw.corpCode.persistence.mapper.MoneySubsidyMapper;
import com.xfw.corpCode.service.SubsidyService;
import com.xfw.work.util.RedisUtil;
import com.xfw.work.util.event.base.EventListener;
import com.xfw.work.util.event.local.Listen;
import java.util.Objects;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class SubsidyNumListener
implements EventListener {
    private static final Logger log = LoggerFactory.getLogger(SubsidyNumListener.class);
    @Resource
    private MoneySubsidyMapper moneySubsidyMapper;
    @Resource
    private RedisUtil redisUtil;
    @Resource
    private SubsidyService subsidyService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Listen
    public void updateNum(SubsidyNumEvent event) {
        block16: {
            Long subsidyId;
            block15: {
                MoneySubsidy moneySubsidy;
                block14: {
                    subsidyId = event.getSubsidyId();
                    while (!this.redisUtil.setIfAbsent("update:money:subsidy:num:lock:" + subsidyId, "running", 20L).booleanValue()) {
                    }
                    moneySubsidy = (MoneySubsidy)this.moneySubsidyMapper.selectByPrimaryKey((Object)subsidyId);
                    if (!Objects.isNull(moneySubsidy)) break block14;
                    log.error("\u4fee\u6539\u6570\u91cf\u65f6\u672a\u67e5\u8be2\u5230\u8be5\u8865\u8d34\u4fe1\u606f:{}", (Object)JSON.toJSONString((Object)event));
                    this.redisUtil.del(new String[]{"update:money:subsidy:num:lock:" + subsidyId});
                    break block16;
                }
                try {
                    Integer type = event.getType();
                    Integer updateType = event.getUpdateType();
                    if (SubsidyNumTypeEnum.QUERY_NUM.getType().equals(type)) {
                        if (SubsidyNumUpdateEnum.ADD.getType().equals(updateType)) {
                            moneySubsidy.setSurplusQueryNum(Integer.valueOf(moneySubsidy.getSurplusQueryNum() + 1));
                        } else if (SubsidyNumUpdateEnum.DEDUCT.getType().equals(updateType)) {
                            moneySubsidy.setSurplusQueryNum(Integer.valueOf(moneySubsidy.getSurplusQueryNum() - 1));
                        }
                    } else if (SubsidyNumUpdateEnum.ADD.getType().equals(updateType)) {
                        moneySubsidy.setSurplusNum(Integer.valueOf(moneySubsidy.getSurplusNum() + 1));
                    } else if (SubsidyNumUpdateEnum.DEDUCT.getType().equals(updateType)) {
                        moneySubsidy.setSurplusNum(Integer.valueOf(moneySubsidy.getSurplusNum() - 1));
                    }
                    this.moneySubsidyMapper.updateByPrimaryKey((Object)moneySubsidy);
                    if (moneySubsidy.getSurplusNum() > 0 && moneySubsidy.getSurplusQueryNum() > 0) break block15;
                    this.subsidyService.updateCanGetMoneySubsidy();
                }
                catch (Exception e) {
                    try {
                        log.error("\u4fee\u6539\u8865\u8d34\u6570\u91cf\u51fa\u9519:\u8865\u8d34id:{},\u9519\u8bef:{}", (Object)subsidyId, (Object)e.getMessage());
                    }
                    catch (Throwable throwable) {
                        this.redisUtil.del(new String[]{"update:money:subsidy:num:lock:" + subsidyId});
                    }
                    this.redisUtil.del(new String[]{"update:money:subsidy:num:lock:" + subsidyId});
                    break block16;
                }
            }
            this.redisUtil.del(new String[]{"update:money:subsidy:num:lock:" + subsidyId});
        }
    }
}

