/*
 * Decompiled with CFR 0.152.
 */
package com.xfw.corpCode.listener;

import com.alibaba.fastjson.JSON;
import com.xfw.common.util.IDGenerator;
import com.xfw.common.util.StringUtils;
import com.xfw.corpCode.listener.RefundEvent;
import com.xfw.corpCode.model.entity.RefundRecord;
import com.xfw.corpCode.model.enums.PayStatusEnum;
import com.xfw.corpCode.model.enums.RefundModeEnum;
import com.xfw.corpCode.persistence.mapper.RefundRecordMapper;
import com.xfw.corpCode.service.SubsidyService;
import com.xfw.work.util.event.base.EventListener;
import com.xfw.work.util.event.local.Listen;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class RefundListener
implements EventListener {
    private static final Logger log = LoggerFactory.getLogger(RefundListener.class);
    @Resource
    private RefundRecordMapper refundRecordMapper;
    @Resource
    private SubsidyService subsidyService;

    @Listen
    public void refund(RefundEvent event) {
        String refund_mode = event.getInput().getRefund_mode();
        String trade_no = event.getInput().getTrade_no();
        if (StringUtils.isBlank((CharSequence)refund_mode) || StringUtils.isBlank((CharSequence)trade_no)) {
            log.error("\u9000\u6b3e\u6a21\u5f0f\u53c2\u6570\u4e3a\u7a7a:{}", (Object)JSON.toJSONString((Object)event));
            return;
        }
        if (refund_mode.equals(RefundModeEnum.RECOVER.getType())) {
            this.subsidyService.updatePayRecordStatus(trade_no, PayStatusEnum.RECOVER.getType());
        }
        if (refund_mode.equals(RefundModeEnum.REFUND.getType())) {
            this.subsidyService.updatePayRecordStatus(trade_no, PayStatusEnum.REFUND.getType());
            RefundRecord refundRecord = new RefundRecord();
            refundRecord.setId(IDGenerator.getId());
            refundRecord.setRefundNo(event.getInput().getRefund_no());
            refundRecord.setRefundAmount(event.getInput().getRefund_amount());
            refundRecord.setTradeNo(trade_no);
            this.refundRecordMapper.insertSelective((Object)refundRecord);
        }
    }
}

