/*
 * Decompiled with CFR 0.152.
 */
package com.xfw.corpCode.listener;

import com.xfw.common.util.IDGenerator;
import com.xfw.corpCode.helper.UserCountTracker;
import com.xfw.corpCode.listener.PayRecordEvent;
import com.xfw.corpCode.model.entity.MoneySubsidyRecord;
import com.xfw.corpCode.model.enums.PayStatusEnum;
import com.xfw.corpCode.model.enums.SubsidyNumTypeEnum;
import com.xfw.corpCode.model.enums.SubsidyNumUpdateEnum;
import com.xfw.corpCode.persistence.mapper.MoneySubsidyRecordMapper;
import com.xfw.corpCode.service.SubsidyService;
import com.xfw.work.util.event.base.EventListener;
import com.xfw.work.util.event.local.Listen;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class PayRecordListener
implements EventListener {
    @Resource
    private SubsidyService subsidyService;
    @Resource
    private MoneySubsidyRecordMapper moneySubsidyRecordMapper;
    @Resource
    private UserCountTracker userCountTracker;

    @Listen
    public void addRecord(PayRecordEvent event) {
        MoneySubsidyRecord existPayRecord = this.subsidyService.isExistPayRecord(event.getInput());
        if (existPayRecord == null) {
            MoneySubsidyRecord moneySubsidyRecord = new MoneySubsidyRecord();
            moneySubsidyRecord.setStatus(PayStatusEnum.DEDUCT.getType());
            moneySubsidyRecord.setId(IDGenerator.getId());
            moneySubsidyRecord.setApplyAmount(event.getInput().getApply_amount());
            moneySubsidyRecord.setSubsidyMoney(event.getQueryRecord().getSubsidyMoney());
            moneySubsidyRecord.setSubsidyId(event.getQueryRecord().getSubsidyId());
            moneySubsidyRecord.setStandardId(event.getInput().getStandard_id());
            moneySubsidyRecord.setBizDate(event.getInput().getBiz_date());
            moneySubsidyRecord.setEmployeeId(event.getInput().getEmployee_id());
            moneySubsidyRecord.setEnterpriseId(event.getInput().getEnterprise_id());
            moneySubsidyRecord.setTradeNo(event.getInput().getTrade_no());
            this.moneySubsidyRecordMapper.insertSelective((Object)moneySubsidyRecord);
        } else {
            MoneySubsidyRecord moneySubsidyRecord = new MoneySubsidyRecord();
            moneySubsidyRecord.setId(existPayRecord.getId());
            moneySubsidyRecord.setStatus(PayStatusEnum.DEDUCT.getType());
            this.moneySubsidyRecordMapper.updateByPrimaryKeySelective((Object)moneySubsidyRecord);
        }
        this.subsidyService.updateSubsidyNum(event.getQueryRecord().getSubsidyId(), SubsidyNumTypeEnum.DEDUCT_NUM.getType(), SubsidyNumUpdateEnum.DEDUCT.getType());
    }
}

