/*
 * Decompiled with CFR 0.152.
 */
package com.xfw.corpCode.listener;

import com.alipay.api.response.AlipayCommerceEcEmployeeAddResponse;
import com.xfw.common.util.IDGenerator;
import com.xfw.corpCode.api.AlipayEnterpriseCodeApiService;
import com.xfw.corpCode.listener.CreateEmployeeEvent;
import com.xfw.corpCode.model.entity.Employee;
import com.xfw.corpCode.model.param.AddEmployeeParam;
import com.xfw.corpCode.persistence.mapper.EmployeeMapper;
import com.xfw.work.util.event.base.EventListener;
import com.xfw.work.util.event.local.Listen;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import tk.mybatis.mapper.entity.Example;

@Service
public class CreateEmployeeListener
implements EventListener {
    @Resource
    private EmployeeMapper employeeMapper;
    @Resource
    private AlipayEnterpriseCodeApiService alipayEnterpriseCodeApiService;
    private String identityType = "ALIPAY_USER_ID";
    private String enterpriseId = "2088720053941421";

    @Listen
    public void addEmployee(CreateEmployeeEvent event) {
        if (this.isExist(event.getDingUserId()).booleanValue()) {
            return;
        }
        AddEmployeeParam addEmployeeParam = new AddEmployeeParam();
        addEmployeeParam.setEnterpriseId(this.enterpriseId);
        addEmployeeParam.setIdentityType(this.identityType);
        addEmployeeParam.setIdentity(event.getIdentity());
        addEmployeeParam.setEmployeeName(event.getEmployeeName());
        AlipayCommerceEcEmployeeAddResponse alipayCommerceEcEmployeeAddResponse = this.alipayEnterpriseCodeApiService.addEmployee(addEmployeeParam);
        Employee employee = new Employee();
        employee.setId(IDGenerator.getId());
        employee.setEmployeeId(alipayCommerceEcEmployeeAddResponse.getEmployeeId());
        employee.setEmployeeName(event.getEmployeeName());
        employee.setIdentity(event.getIdentity());
        employee.setIdentityType(this.identityType);
        employee.setEnterpriseId(this.enterpriseId);
        employee.setAvatar(event.getAvatar());
        employee.setDingUserId(event.getDingUserId());
        this.employeeMapper.insertSelective((Object)employee);
    }

    private Boolean isExist(String dingUserId) {
        Example example = new Example(Employee.class);
        example.createCriteria().andEqualTo("dingUserId", (Object)dingUserId);
        int i = this.employeeMapper.selectCountByExample((Object)example);
        return i > 0;
    }
}

