/*
 * Decompiled with CFR 0.152.
 */
package com.xfw.corpCode.helper;

import com.alibaba.fastjson.JSON;
import com.xfw.corpCode.model.vo.QueryRecord;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class UserMoneyRecordTracker {
    private static final String PREFIX = "user_day_money_record:";
    private static final SimpleDateFormat DATE_FORMATTER = new SimpleDateFormat("yyyy-MM-dd");
    @Resource
    private RedisTemplate<String, String> redisTemplate;

    public void addRecord(String userId, BigDecimal subsidyMoney, Long subsidyId) {
        String key = this.generateKey(userId, new Date());
        QueryRecord queryRecord = new QueryRecord();
        queryRecord.setSubsidyMoney(subsidyMoney);
        queryRecord.setSubsidyId(subsidyId);
        queryRecord.setQueryDate(new Date());
        this.redisTemplate.opsForList().leftPush((Object)key, (Object)JSON.toJSONString((Object)queryRecord));
        this.redisTemplate.expire((Object)key, 24L, TimeUnit.HOURS);
    }

    public void deleteUserRecord(String userId, Date currentDate, BigDecimal subsidyMoney) {
        String key = this.generateKey(userId, currentDate);
        List data = this.redisTemplate.opsForList().range((Object)key, 0L, -1L);
        if (CollectionUtils.isEmpty((Collection)data)) {
            return;
        }
        for (String s : data) {
            QueryRecord queryRecord = (QueryRecord)JSON.parseObject((String)s, QueryRecord.class);
            if (queryRecord.getSubsidyMoney().compareTo(subsidyMoney) != 0) continue;
            this.redisTemplate.opsForList().remove((Object)key, 1L, (Object)s);
            return;
        }
    }

    public QueryRecord getRecord(String userId, BigDecimal orderMoney) {
        String key = this.generateKey(userId, new Date());
        List data = this.redisTemplate.opsForList().range((Object)key, 0L, -1L);
        if (CollectionUtils.isEmpty((Collection)data)) {
            return null;
        }
        Collections.shuffle(data);
        for (String s : data) {
            QueryRecord queryRecord = (QueryRecord)JSON.parseObject((String)s, QueryRecord.class);
            if (queryRecord.getSubsidyMoney().compareTo(orderMoney) >= 0) continue;
            return queryRecord;
        }
        return null;
    }

    private String generateKey(String userId, Date date) {
        return PREFIX + userId + ":" + DATE_FORMATTER.format(date);
    }
}

