/*
 * Decompiled with CFR 0.152.
 */
package com.xfw.corpCode.helper;

import com.xfw.work.util.RedisUtil;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Objects;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class UserCountTracker {
    private static final Logger log = LoggerFactory.getLogger(UserCountTracker.class);
    private static final String PREFIX = "user_day_subsidy:";
    private static final String MAX_COUNT = "max_count";
    private static final SimpleDateFormat DATE_FORMATTER = new SimpleDateFormat("yyyy-MM-dd");
    @Resource
    private RedisUtil redisUtil;

    public void recordUserCount(String userId, Date currentDate) {
        String key = this.generateKey(userId, currentDate);
        this.incrementCount(key);
    }

    public boolean isReachedTimes(String userId, Date currentDate) {
        String key = this.generateKey(userId, currentDate);
        Object o = this.redisUtil.getIncr(key);
        Object i = this.redisUtil.getIncr(MAX_COUNT);
        long maxCount = 2L;
        if (!Objects.isNull(i)) {
            maxCount = Long.parseLong(String.valueOf(i));
        }
        long currentCount = Objects.isNull(o) ? 0L : Long.parseLong(o.toString());
        return currentCount >= maxCount;
    }

    private String generateKey(String userId, Date date) {
        return PREFIX + userId + ":" + DATE_FORMATTER.format(date);
    }

    private void incrementCount(String key) {
        this.redisUtil.incr(key, 1L);
        this.redisUtil.expireHour(key, 24L);
    }
}

