/*
 * Decompiled with CFR 0.152.
 */
package com.xfw.corpCode.helper;

import com.xfw.common.structure.Pair;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;

public class ProbabilityRandomPicker<T> {
    private final Map<T, Double> probabilities;
    private final Random random;

    public ProbabilityRandomPicker(List<Pair<T, Double>> items) {
        this.probabilities = items.stream().collect(Collectors.toMap(Pair::getX, Pair::getY));
        double sum = this.probabilities.values().stream().mapToDouble(Double::doubleValue).sum();
        if (Math.abs(sum - 1.0) > 1.0E-6) {
            throw new IllegalArgumentException("Probabilities must sum to 1.0");
        }
        this.random = new Random();
    }

    public T getRandomItem() {
        double randomValue = this.random.nextDouble();
        double cumulativeProbability = 0.0;
        for (Map.Entry entry : this.probabilities.entrySet()) {
            if (!(randomValue <= (cumulativeProbability += ((Double)entry.getValue()).doubleValue()))) continue;
            return (T)entry.getKey();
        }
        throw new IllegalStateException("Unexpected state in probability distribution.");
    }
}

