/*
 * Decompiled with CFR 0.152.
 */
package com.xfw.corpCode.helper;

import com.xfw.corpCode.model.entity.MoneySubsidyRecord;
import com.xfw.corpCode.model.entity.RefundRecord;
import com.xfw.corpCode.model.enums.PayStatusEnum;
import com.xfw.corpCode.model.response.ExpenseControlConsultResultResponse;
import com.xfw.corpCode.model.response.ExpenseControlQuotaPayResultResponse;
import com.xfw.corpCode.model.response.ExpenseControlQuotaRefundResultResponse;
import com.xfw.corpCode.model.response.ExpenseControlQuotaStatusQueryResultResponse;
import com.xfw.corpCode.model.response.QuotaDeductInfo;
import com.xfw.corpCode.model.response.QuotaRefundInfo;
import java.util.ArrayList;
import java.util.List;
import org.assertj.core.util.Lists;

public class CorpCodeHelper {
    public static List<ExpenseControlConsultResultResponse> getConsultFailResData(List<String> standardIds, String resultCode, String resultMsg) {
        ArrayList data = Lists.newArrayList();
        standardIds.forEach(n -> {
            ExpenseControlConsultResultResponse expenseControlConsultResultResponse = new ExpenseControlConsultResultResponse();
            expenseControlConsultResultResponse.setResult_code(resultCode);
            expenseControlConsultResultResponse.setResult_msg(resultMsg);
            expenseControlConsultResultResponse.setConsult_status(false);
            expenseControlConsultResultResponse.setStandard_id(n);
            data.add(expenseControlConsultResultResponse);
        });
        return data;
    }

    public static List<ExpenseControlConsultResultResponse> getConsultSucResData(List<String> standardIds, Integer availableAmount) {
        ArrayList data = Lists.newArrayList();
        standardIds.forEach(n -> {
            ExpenseControlConsultResultResponse expenseControlConsultResultResponse = new ExpenseControlConsultResultResponse();
            expenseControlConsultResultResponse.setAvailable_amount(availableAmount);
            expenseControlConsultResultResponse.setConsult_status(true);
            expenseControlConsultResultResponse.setStandard_id(n);
            data.add(expenseControlConsultResultResponse);
        });
        return data;
    }

    public static ExpenseControlQuotaRefundResultResponse getRefundSucResData() {
        ExpenseControlQuotaRefundResultResponse res = new ExpenseControlQuotaRefundResultResponse();
        res.setResult(Boolean.valueOf(true));
        return res;
    }

    public static ExpenseControlQuotaRefundResultResponse getRefundFailResData(String result_code, String result_msg) {
        ExpenseControlQuotaRefundResultResponse res = new ExpenseControlQuotaRefundResultResponse();
        res.setResult(Boolean.valueOf(false));
        res.setResult_msg(result_msg);
        res.setResult_code(result_code);
        return res;
    }

    public static ExpenseControlQuotaPayResultResponse getPaySucResData() {
        ExpenseControlQuotaPayResultResponse res = new ExpenseControlQuotaPayResultResponse();
        res.setResult(Boolean.valueOf(true));
        return res;
    }

    public static ExpenseControlQuotaPayResultResponse getPayFailResData(String result_code, String result_msg) {
        ExpenseControlQuotaPayResultResponse res = new ExpenseControlQuotaPayResultResponse();
        res.setResult_code(result_code);
        res.setResult_msg(result_msg);
        res.setResult(Boolean.valueOf(false));
        return res;
    }

    public static ExpenseControlQuotaStatusQueryResultResponse getQueryData(MoneySubsidyRecord payRecordByTradeNo, List<RefundRecord> refundRecordList) {
        ExpenseControlQuotaStatusQueryResultResponse res = new ExpenseControlQuotaStatusQueryResultResponse();
        QuotaDeductInfo quotaDeductInfo = new QuotaDeductInfo();
        quotaDeductInfo.setAmount(payRecordByTradeNo.getApplyAmount());
        quotaDeductInfo.setStandard_id(payRecordByTradeNo.getStandardId());
        quotaDeductInfo.setTrade_no(payRecordByTradeNo.getTradeNo());
        quotaDeductInfo.setStatus(PayStatusEnum.getNameByType((Integer)payRecordByTradeNo.getStatus()));
        res.setQuota_deduct_info(quotaDeductInfo);
        res.setQuota_refund_info_list((List)Lists.newArrayList());
        refundRecordList.forEach(refundRecord -> {
            QuotaRefundInfo quotaRefundInfo = new QuotaRefundInfo();
            quotaRefundInfo.setRefund_amount(refundRecord.getRefundAmount());
            quotaRefundInfo.setRefund_no(refundRecord.getRefundNo());
            quotaRefundInfo.setTrade_no(refundRecord.getTradeNo());
            res.getQuota_refund_info_list().add(quotaRefundInfo);
        });
        return res;
    }

    public static ExpenseControlQuotaStatusQueryResultResponse getQueryEmptyData() {
        ExpenseControlQuotaStatusQueryResultResponse res = new ExpenseControlQuotaStatusQueryResultResponse();
        res.setQuota_refund_info_list(null);
        res.setQuota_deduct_info(null);
        return res;
    }
}

