/*
 * Decompiled with CFR 0.152.
 */
package com.xfw.corpCode.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.alipay.api.AlipayApiException;
import com.alipay.api.internal.util.AlipaySignature;
import com.xfw.corpCode.model.param.ConsultExpensecontrolParam;
import com.xfw.corpCode.model.param.QueryPayParam;
import com.xfw.corpCode.model.param.QueryQuotastatusParam;
import com.xfw.corpCode.model.param.QuotaRefundParam;
import com.xfw.corpCode.service.impl.CorpCodeServiceImpl;
import com.xfw.work.config.annotation.NotNeedLoginToken;
import com.xfw.work.config.annotation.PassToken;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/an"})
public class CorpCodeController {
    private static final Logger log = LoggerFactory.getLogger(CorpCodeController.class);
    @Autowired
    private CorpCodeServiceImpl corpCodeServiceImpl;
    @Value(value="${alipay.publicKey}")
    private String alipayPublicKey;
    @Value(value="${alipay.privateKey}")
    private String isvPrivateKey;

    @PostMapping(value={"consultExpenseControl"})
    @PassToken
    @NotNeedLoginToken
    public String consultExpenseControl(@RequestParam Map<String, String> params) {
        Long startTi = System.currentTimeMillis();
        ConsultExpensecontrolParam input = (ConsultExpensecontrolParam)JSON.parseObject((String)JSON.toJSONString(params), (TypeReference)new /* Unavailable Anonymous Inner Class!! */, (Feature[])new Feature[0]);
        String standard_id_list = params.get("standard_id_list");
        String ids = standard_id_list.replaceAll("\"", "");
        List list = Arrays.stream(ids.substring(1, ids.length() - 1).split(",")).map(String::trim).collect(Collectors.toList());
        input.setStandard_id_list(list);
        JSONObject data = new JSONObject();
        JSONObject response = new JSONObject();
        response.put("result", (Object)this.corpCodeServiceImpl.consultExpensecontrol(input));
        response.put("code", (Object)"10000");
        response.put("msg", (Object)"Success");
        data.put("response", (Object)response);
        log.info("\u8fd4\u56de\u54a8\u8be2\u989d\u5ea6:{}", (Object)JSON.toJSONString((Object)data));
        String res = this.signResult(response);
        Long endTi = System.currentTimeMillis();
        return res;
    }

    @PostMapping(value={"payQuota"})
    @PassToken
    @NotNeedLoginToken
    public String payQuota(@RequestParam Map<String, String> params) {
        Long startTi = System.currentTimeMillis();
        QueryPayParam input = (QueryPayParam)JSON.parseObject((String)JSON.toJSONString(params), (TypeReference)new /* Unavailable Anonymous Inner Class!! */, (Feature[])new Feature[0]);
        JSONObject response = new JSONObject();
        response.put("result", (Object)this.corpCodeServiceImpl.quotaPay(input));
        response.put("code", (Object)"10000");
        response.put("msg", (Object)"Success");
        String res = this.signResult(response);
        Long endTi = System.currentTimeMillis();
        log.info("\u6263\u8d39\u63a5\u53e3\u8017\u65f6:{}", (Object)(endTi - startTi));
        return res;
    }

    @PostMapping(value={"refundQuota"})
    @PassToken
    @NotNeedLoginToken
    public String refundQuota(@RequestParam Map<String, String> params) {
        QuotaRefundParam input = (QuotaRefundParam)JSON.parseObject((String)JSON.toJSONString(params), (TypeReference)new /* Unavailable Anonymous Inner Class!! */, (Feature[])new Feature[0]);
        JSONObject response = new JSONObject();
        response.put("result", (Object)this.corpCodeServiceImpl.quotaRefund(input));
        response.put("code", (Object)"10000");
        response.put("msg", (Object)"Success");
        return this.signResult(response);
    }

    @PostMapping(value={"queryQuotastatus"})
    @NotNeedLoginToken
    public String queryQuotastatus(@RequestParam Map<String, String> params) {
        QueryQuotastatusParam input = (QueryQuotastatusParam)JSON.parseObject((String)JSON.toJSONString(params), (TypeReference)new /* Unavailable Anonymous Inner Class!! */, (Feature[])new Feature[0]);
        JSONObject response = new JSONObject();
        response.put("result", (Object)this.corpCodeServiceImpl.queryQuotastatus(input));
        response.put("code", (Object)"10000");
        response.put("msg", (Object)"Success");
        return this.signResult(response);
    }

    private Boolean checkSign(Map<String, String> params) {
        try {
            boolean isPass = AlipaySignature.rsaCheckV1(params, (String)this.alipayPublicKey, (String)"UTF-8", (String)"RSA2");
            return isPass;
        }
        catch (AlipayApiException e) {
            return false;
        }
    }

    private JSONObject getFailSignRes() {
        JSONObject response = new JSONObject();
        response.put("code", (Object)"40004");
        response.put("msg", (Object)"Business Failed");
        response.put("sub_code", (Object)"ISV-VERIFICATION-FAILED");
        response.put("sub_msg", (Object)"\u9a8c\u7b7e\u5931\u8d25");
        return response;
    }

    private String signResult(JSONObject res) {
        String resStr = res.toJSONString();
        JSONObject result = new JSONObject();
        try {
            String sign = AlipaySignature.rsaSign((String)resStr, (String)this.isvPrivateKey, (String)"UTF-8", (String)"RSA2");
            result.put("sign", (Object)sign);
            result.put("response", (Object)res);
            return result.toJSONString();
        }
        catch (Exception e) {
            return "\u7ed3\u679c\u52a0\u7b7e\u9519\u8bef";
        }
    }
}

