/*
 * Decompiled with CFR 0.152.
 */
package com.xfw.corpCode.controller;

import com.alipay.api.response.AlipayCommerceEcEmployeeAddResponse;
import com.alipay.api.response.AlipayCommerceEcEmployeeInfoQueryResponse;
import com.xfw.corpCode.api.AlipayEnterpriseCodeApiService;
import com.xfw.corpCode.model.param.AddEmployeeParam;
import com.xfw.corpCode.model.param.CreateInstitutionParam;
import com.xfw.corpCode.model.param.DeleteInstitutionParam;
import com.xfw.corpCode.model.param.InstitutionScopeParam;
import com.xfw.corpCode.model.param.QueryEmployeeInfoParam;
import com.xfw.corpCode.model.param.QueryEmployeeInviteParam;
import com.xfw.corpCode.model.param.QuotaCreateParam;
import com.xfw.corpCode.model.param.QuotaModifyParam;
import com.xfw.corpCode.model.param.UpdateEnterpriseParam;
import com.xfw.corpCode.service.CorpCodeBizService;
import com.xfw.work.config.annotation.NotNeedLoginToken;
import com.xfw.work.config.annotation.PassToken;
import com.xfw.work.model.common.ServiceResult;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/corpCode/biz"})
public class CorpCodeBizController {
    @Resource
    private CorpCodeBizService corpCodeBizService;
    @Resource
    private AlipayEnterpriseCodeApiService alipayEnterpriseCodeApiService;

    @PostMapping(value={"createInstitution"})
    @NotNeedLoginToken
    public ServiceResult createInstitution(@RequestBody CreateInstitutionParam input) {
        this.corpCodeBizService.addInstitution(input);
        return ServiceResult.getSuccessResult();
    }

    @PostMapping(value={"deleteInstitution"})
    @NotNeedLoginToken
    public ServiceResult deleteInstitution(@RequestBody DeleteInstitutionParam input) {
        this.corpCodeBizService.deleteInstitution(input);
        return ServiceResult.getSuccessResult();
    }

    @PostMapping(value={"scopeModify"})
    @NotNeedLoginToken
    public ServiceResult scopeModify(@RequestBody InstitutionScopeParam input) {
        return ServiceResult.getSuccessResult((Object)this.alipayEnterpriseCodeApiService.institutionScopeModify(input));
    }

    @PostMapping(value={"queryEmployeeInvite"})
    @NotNeedLoginToken
    public ServiceResult queryEmployeeInvite(@RequestBody QueryEmployeeInviteParam input) {
        return ServiceResult.getSuccessResult((Object)this.alipayEnterpriseCodeApiService.queryEmployeeInvite(input));
    }

    @PostMapping(value={"updateEnterprise"})
    @NotNeedLoginToken
    public ServiceResult updateEnterprise(@RequestBody UpdateEnterpriseParam input) {
        return ServiceResult.getSuccessResult((Object)this.alipayEnterpriseCodeApiService.updateEnterprise(input));
    }

    @PostMapping(value={"createUser"})
    @NotNeedLoginToken
    public ServiceResult createUser(@RequestBody AddEmployeeParam input) {
        AlipayCommerceEcEmployeeAddResponse alipayCommerceEcEmployeeAddResponse = this.alipayEnterpriseCodeApiService.addEmployee(input);
        return ServiceResult.getSuccessResult((Object)alipayCommerceEcEmployeeAddResponse);
    }

    @PostMapping(value={"queryUser"})
    @NotNeedLoginToken
    public ServiceResult queryUser(@RequestBody QueryEmployeeInfoParam input) {
        AlipayCommerceEcEmployeeInfoQueryResponse alipayCommerceEcEmployeeAddResponse = this.alipayEnterpriseCodeApiService.queryEmployeeInfo(input);
        return ServiceResult.getSuccessResult((Object)alipayCommerceEcEmployeeAddResponse);
    }

    @GetMapping(value={"login"})
    public ServiceResult login(String code, String userId, String userName) {
        return ServiceResult.getSuccessResult((Object)this.corpCodeBizService.login(code, userId, userName));
    }

    @GetMapping(value={"updateStandardRedis"})
    @PassToken
    @NotNeedLoginToken
    public ServiceResult updateStandardRedis() {
        this.corpCodeBizService.updateStandardRedis();
        return ServiceResult.getSuccessResult();
    }

    @PostMapping(value={"quotaCreate"})
    @NotNeedLoginToken
    public ServiceResult quotaCreate(@RequestBody QuotaCreateParam input) {
        return ServiceResult.getSuccessResult((Object)this.alipayEnterpriseCodeApiService.quotaCreate(input));
    }

    @PostMapping(value={"quotaModify"})
    @NotNeedLoginToken
    public ServiceResult quotaModify(@RequestBody QuotaModifyParam input) {
        return ServiceResult.getSuccessResult((Object)this.alipayEnterpriseCodeApiService.quotaModify(input));
    }

    @GetMapping(value={"enterpriseDelete"})
    @NotNeedLoginToken
    public ServiceResult enterpriseDelete(String enterpriseId) {
        return ServiceResult.getSuccessResult((Object)this.alipayEnterpriseCodeApiService.enterpriseDelete(enterpriseId));
    }
}

