/*
 * Decompiled with CFR 0.152.
 */
package vip.forwe.am.web.controller.system;

import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;
import vip.forwe.am.common.core.domain.AjaxResult;
import vip.forwe.am.common.core.domain.entity.SysUser;
import vip.forwe.am.common.core.domain.model.LoginBody;
import vip.forwe.am.common.utils.SecurityUtils;
import vip.forwe.am.framework.web.service.SysLoginService;
import vip.forwe.am.framework.web.service.SysPermissionService;
import vip.forwe.am.system.service.ISysMenuService;

@RestController
public class SysLoginController {
    @Autowired
    private SysLoginService loginService;
    @Autowired
    private ISysMenuService menuService;
    @Autowired
    private SysPermissionService permissionService;

    @PostMapping(value={"/login"})
    public AjaxResult login(@RequestBody LoginBody loginBody) {
        AjaxResult ajax = AjaxResult.success();
        String token = this.loginService.login(loginBody.getUsername(), loginBody.getPassword(), loginBody.getCode(), loginBody.getUuid());
        ajax.put("token", (Object)token);
        return ajax;
    }

    @GetMapping(value={"getInfo"})
    public AjaxResult getInfo() {
        SysUser user = SecurityUtils.getLoginUser().getUser();
        Set roles = this.permissionService.getRolePermission(user);
        Set permissions = this.permissionService.getMenuPermission(user);
        AjaxResult ajax = AjaxResult.success();
        ajax.put("user", (Object)user);
        ajax.put("roles", (Object)roles);
        ajax.put("permissions", (Object)permissions);
        return ajax;
    }

    @GetMapping(value={"getRouters"})
    public AjaxResult getRouters() {
        Long userId = SecurityUtils.getUserId();
        List menus = this.menuService.selectMenuTreeByUserId(userId);
        return AjaxResult.success((Object)this.menuService.buildMenus(menus));
    }
}

