/*
 * Decompiled with CFR 0.152.
 */
package vip.forwe.am.web.controller.activity;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import vip.forwe.am.activity.service.IAcActivityService;
import vip.forwe.am.activity.vo.request.ActivityPublishRequest;
import vip.forwe.am.activity.vo.request.AddActivityDraftRequest;
import vip.forwe.am.activity.vo.request.QueryActivityPageRequest;
import vip.forwe.am.common.annotation.Log;
import vip.forwe.am.common.core.controller.BaseController;
import vip.forwe.am.common.core.domain.AjaxResult;
import vip.forwe.am.common.core.page.TableDataInfo;
import vip.forwe.am.common.enums.BusinessType;

@Api(tags={"\u6d3b\u52a8\u7ba1\u7406\u76f8\u5173\u63a5\u53e3"})
@RestController
@RequestMapping(value={"/activity"})
public class AcActivityController
extends BaseController {
    @Autowired
    private IAcActivityService acActivityService;

    @ApiOperation(value="\u67e5\u8be2\u6d3b\u52a8\u9891\u9053\u5206\u9875\u5217\u8868")
    @PreAuthorize(value="@ss.hasPermi('ac:activity:list')")
    @GetMapping(value={"/page"})
    public TableDataInfo list(QueryActivityPageRequest request) {
        this.startPage();
        List list = this.acActivityService.selectPage(request);
        return this.getDataTable(list);
    }

    @ApiOperation(value="\u83b7\u53d6\u6d3b\u52a8\u9891\u9053\u8be6\u7ec6\u4fe1\u606f")
    @PreAuthorize(value="@ss.hasPermi('ac:activity:query')")
    @GetMapping(value={"/{id}"})
    public AjaxResult detail(@PathVariable(value="id") Long id) {
        return AjaxResult.success((Object)this.acActivityService.getDetail(id));
    }

    @ApiOperation(value="\u83b7\u53d6\u6d3b\u52a8\u9891\u9053\u8349\u7a3f\u8be6\u7ec6\u4fe1\u606f")
    @PreAuthorize(value="@ss.hasPermi('ac:activity:query')")
    @GetMapping(value={"/{id}/draft"})
    public AjaxResult detailDraft(@PathVariable(value="id") Long id) {
        return AjaxResult.success((Object)this.acActivityService.getDetailDraft(id));
    }

    @PreAuthorize(value="@ss.hasPermi('ac:activity:draft')")
    @Log(title="\u65b0\u589e/\u7f16\u8f91\u6d3b\u52a8\u9891\u9053\u5230\u8349\u7a3f\u72b6\u6001", businessType=BusinessType.INSERT)
    @PostMapping(value={"/draft"})
    @ApiOperation(value="\u65b0\u589e/\u7f16\u8f91\u6d3b\u52a8\u9891\u9053\u5230\u8349\u7a3f\u72b6\u6001")
    public AjaxResult addDraft(@Valid @RequestBody AddActivityDraftRequest request) {
        return this.toAjax(this.acActivityService.addDraft(request));
    }

    @ApiOperation(value="\u53d1\u5e03\u6d3b\u52a8")
    @PreAuthorize(value="@ss.hasPermi('ac:activity:publish')")
    @Log(title="\u6d3b\u52a8\u9891\u9053\u53d1\u5e03", businessType=BusinessType.UPDATE)
    @PostMapping(value={"/publish"})
    public AjaxResult publish(@Valid @RequestBody ActivityPublishRequest request) {
        return this.toAjax(this.acActivityService.publish(request));
    }
}

