/*
 * Decompiled with CFR 0.152.
 */
package vip.forwe.am.web.controller.monitor;

import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import vip.forwe.am.common.annotation.Log;
import vip.forwe.am.common.core.controller.BaseController;
import vip.forwe.am.common.core.domain.AjaxResult;
import vip.forwe.am.common.core.page.TableDataInfo;
import vip.forwe.am.common.enums.BusinessType;
import vip.forwe.am.common.utils.poi.ExcelUtil;
import vip.forwe.am.system.domain.SysOperLog;
import vip.forwe.am.system.service.ISysOperLogService;

@RestController
@RequestMapping(value={"/monitor/operlog"})
public class SysOperlogController
extends BaseController {
    @Autowired
    private ISysOperLogService operLogService;

    @PreAuthorize(value="@ss.hasPermi('monitor:operlog:list')")
    @GetMapping(value={"/list"})
    public TableDataInfo list(SysOperLog operLog) {
        this.startPage();
        List list = this.operLogService.selectOperLogList(operLog);
        return this.getDataTable(list);
    }

    @Log(title="\u64cd\u4f5c\u65e5\u5fd7", businessType=BusinessType.EXPORT)
    @PreAuthorize(value="@ss.hasPermi('monitor:operlog:export')")
    @PostMapping(value={"/export"})
    public void export(HttpServletResponse response, SysOperLog operLog) {
        List list = this.operLogService.selectOperLogList(operLog);
        ExcelUtil util = new ExcelUtil(SysOperLog.class);
        util.exportExcel(response, list, "\u64cd\u4f5c\u65e5\u5fd7");
    }

    @Log(title="\u64cd\u4f5c\u65e5\u5fd7", businessType=BusinessType.DELETE)
    @PreAuthorize(value="@ss.hasPermi('monitor:operlog:remove')")
    @DeleteMapping(value={"/{operIds}"})
    public AjaxResult remove(@PathVariable Long[] operIds) {
        return this.toAjax(this.operLogService.deleteOperLogByIds(operIds));
    }

    @Log(title="\u64cd\u4f5c\u65e5\u5fd7", businessType=BusinessType.CLEAN)
    @PreAuthorize(value="@ss.hasPermi('monitor:operlog:remove')")
    @DeleteMapping(value={"/clean"})
    public AjaxResult clean() {
        this.operLogService.cleanOperLog();
        return AjaxResult.success();
    }
}

