/*
 * Decompiled with CFR 0.152.
 */
package vip.forwe.am.web.controller.fission;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Calendar;
import javax.annotation.Resource;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import vip.forwe.am.activity.config.FissionTeamConfig;
import vip.forwe.am.activity.service.IFissionCommissionStepService;
import vip.forwe.am.activity.service.IFissionTeamMemberService;
import vip.forwe.am.activity.service.IFissionTeamService;
import vip.forwe.am.activity.vo.request.AddFissionTeamRequest;
import vip.forwe.am.activity.vo.request.JoinFissionTeamRequest;
import vip.forwe.am.activity.vo.request.QueryTeamDetailRequest;
import vip.forwe.am.activity.vo.request.QueryUserTeamIdRequest;
import vip.forwe.am.common.annotation.RepeatSubmit;
import vip.forwe.am.common.core.controller.BaseController;
import vip.forwe.am.common.core.domain.AjaxResult;

@Api(tags={"\u88c2\u53d8\u7ec4\u56e2\u63a5\u53e3"})
@RestController
@RequestMapping(value={"/fission/team"})
public class TeamController
extends BaseController {
    @Autowired
    private IFissionTeamService teamService;
    @Autowired
    private IFissionTeamMemberService teamMemberService;
    @Autowired
    private IFissionCommissionStepService commissionStepService;
    @Resource
    private FissionTeamConfig fissionTeamConfig;

    @ApiOperation(value="\u83b7\u53d6\u7ec4\u56e2\u7684\u4e0b\u4e00\u4e2a\u9636\u68af")
    @GetMapping(value={"/step/next/{teamId}"})
    public AjaxResult getTeamNextStep(@PathVariable(value="teamId") Long teamId) {
        return AjaxResult.success((Object)this.commissionStepService.getNextStep(teamId));
    }

    @ApiOperation(value="\u5f00\u56e2")
    @PostMapping
    @RepeatSubmit
    public AjaxResult add(@RequestBody @Valid AddFissionTeamRequest request) {
        return AjaxResult.success((Object)this.teamService.add(request));
    }

    @ApiOperation(value="\u52a0\u5165\u7ec4\u56e2")
    @PostMapping(value={"/join"})
    @RepeatSubmit
    public AjaxResult join(@RequestBody @Valid JoinFissionTeamRequest request) {
        return this.toAjax(this.teamService.join(request).intValue());
    }

    @ApiOperation(value="\u83b7\u53d6\u56e2\u961f\u6210\u5458")
    @GetMapping(value={""})
    public AjaxResult detail(@Valid QueryTeamDetailRequest request) {
        return AjaxResult.success((Object)this.teamMemberService.getTeamMembers(request.getTeamId(), request.getUnionId()));
    }

    @ApiOperation(value="\u83b7\u53d6\u7528\u6237\u6700\u65b0\u53c2\u56e2\u7684ID")
    @GetMapping(value={"/getUserTeamId"})
    public AjaxResult getUserTeamId(QueryUserTeamIdRequest request) {
        return AjaxResult.success((Object)this.teamService.getUserTeamId(request));
    }

    @ApiOperation(value="\u662f\u5426\u53ef\u4ee5\u7ec4\u961f")
    @GetMapping(value={"/isCreateTeam"})
    public AjaxResult isCreateTeam() {
        Calendar calendar = Calendar.getInstance();
        Integer hour = calendar.get(11);
        if (hour < this.fissionTeamConfig.getStartHour()) {
            return AjaxResult.success((Object)false);
        }
        return AjaxResult.success((Object)true);
    }
}

